/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.project.email;

import com.epam.ta.reportportal.ws.annotations.In;
import com.epam.ta.reportportal.ws.annotations.NotBlankStringCollection;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SenderCaseDTO
implements Serializable {
    private static final long serialVersionUID = -3546546654348861010L;
    @NotEmpty
    @NotBlankStringCollection
    @JsonProperty(value="recipients")
    private List<String> recipients;
    @NotBlank
    @JsonProperty(value="sendCase")
    @In(allowedValues={"always", "failed", "toInvestigate", "more10", "more20", "more50"})
    @ApiModelProperty(allowableValues="ALWAYS, FAILED, MORE_10, MORE_20, MORE_50")
    private String sendCase;
    @NotBlankStringCollection
    @JsonProperty(value="launchNames")
    private List<String> launchNames;
    @Valid
    @JsonProperty(value="attributes")
    private Set<ItemAttributeResource> attributes;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @NotBlank
    @JsonProperty(value="attributesOperator")
    @In(allowedValues={"and", "or"})
    @ApiModelProperty(allowableValues="AND, OR")
    private String attributesOperator;

    public SenderCaseDTO() {
    }

    public SenderCaseDTO(List<String> recs, String sendMode, List<String> laNames, Set<ItemAttributeResource> attributes, boolean enabled, String attributesOperator) {
        this.recipients = recs;
        this.sendCase = sendMode;
        this.launchNames = laNames;
        this.attributes = attributes;
        this.enabled = enabled;
        this.attributesOperator = attributesOperator;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setSendCase(String value) {
        this.sendCase = value;
    }

    public String getSendCase() {
        return this.sendCase;
    }

    public void setLaunchNames(List<String> value) {
        this.launchNames = value;
    }

    public List<String> getLaunchNames() {
        return this.launchNames;
    }

    public Set<ItemAttributeResource> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributeResource> attributes) {
        this.attributes = attributes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getAttributesOperator() {
        return this.attributesOperator;
    }

    public void setAttributesOperator(String attributesOperator) {
        this.attributesOperator = attributesOperator;
    }

    public String toString() {
        return "SenderCaseDTO{recipients=" + this.recipients + ", sendCase='" + this.sendCase + '\'' + ", launchNames=" + this.launchNames + ", attributes=" + this.attributes + ", enabled=" + this.enabled + ", attributesOperator=" + this.attributesOperator + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SenderCaseDTO that = (SenderCaseDTO)o;
        return Objects.equals(this.recipients, that.recipients) && Objects.equals(this.sendCase, that.sendCase) && Objects.equals(this.launchNames, that.launchNames) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.attributesOperator, that.attributesOperator);
    }

    public int hashCode() {
        return Objects.hash(this.recipients, this.sendCase, this.launchNames, this.attributes, this.enabled, this.attributesOperator);
    }
}

