/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.commons.template;

import com.epam.reportportal.commons.template.FreemarkerTemplateEngine;
import com.epam.reportportal.commons.template.TemplateEngine;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.util.Locale;
import javax.inject.Provider;

public class TemplateEngineProvider
implements Provider<TemplateEngine> {
    private final String basePackagePath;

    public TemplateEngineProvider() {
        this("/");
    }

    public TemplateEngineProvider(String basePackagePath) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)basePackagePath) ? 1 : 0) != 0, (Object)"Base path for templates is missed");
        this.basePackagePath = basePackagePath;
    }

    public TemplateEngine get() {
        Version version = new Version(2, 3, 25);
        Configuration cfg = new Configuration(version);
        cfg.setClassForTemplateLoading(this.getClass(), this.basePackagePath);
        cfg.setIncompatibleImprovements(version);
        cfg.setDefaultEncoding(Charsets.UTF_8.toString());
        cfg.setLocale(Locale.US);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return new FreemarkerTemplateEngine(cfg);
    }
}

