/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.commons;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Safe {
    private static final Logger LOGGER = LoggerFactory.getLogger(Safe.class);
    private final Action work;
    private final Consumer<Exception> errorCallback;

    private Safe(Action work, Consumer<Exception> errorCallback) {
        this.work = work;
        this.errorCallback = errorCallback;
    }

    public static void safe(Action action) {
        new Safe(action, null).perform();
    }

    public static void safe(Action action, Consumer<Exception> errorCallback) {
        new Safe(action, errorCallback).perform();
    }

    private void perform() {
        try {
            this.work.perform();
        }
        catch (Exception e) {
            if (null != this.errorCallback) {
                this.errorCallback.accept(e);
            }
            LOGGER.error("Exception appears in safe block, but not handled. Ignoring...", (Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void perform() throws Exception;
    }
}

