/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.commons;

import com.epam.reportportal.commons.ContentTypeResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaContentTypeResolver
implements ContentTypeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TikaContentTypeResolver.class);

    @Override
    public String detectContentType(byte[] data) {
        return this.detectContentType(new ByteArrayInputStream(data));
    }

    @Override
    public String detectContentType(InputStream data) {
        return this.detectContentType(TikaInputStream.get((InputStream)data));
    }

    @Override
    public String detectContentType(Path data) {
        try {
            return this.detectContentType(TikaInputStream.get((Path)data));
        }
        catch (IOException e) {
            LOGGER.error("Cannot read data stream", (Throwable)e);
            return MediaType.OCTET_STREAM.toString();
        }
    }

    private String detectContentType(TikaInputStream is) {
        try {
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            MediaType mediaType = detector.detect((InputStream)is, new Metadata());
            return mediaType.toString();
        }
        catch (IOException e) {
            LOGGER.error("Cannot read data stream", (Throwable)e);
            return MediaType.OCTET_STREAM.toString();
        }
    }
}

