/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActivityResource {
    @NotNull
    @JsonProperty(value="id", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The unique ID of the activity", example="1")
    private Long id;
    @NotNull
    @JsonProperty(value="user", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The user who performed the activity", example="user")
    private String user;
    @NotNull
    @JsonProperty(value="loggedObjectId", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the object on which activity was performed", example="1")
    private Long loggedObjectId;
    @NotNull
    @JsonProperty(value="lastModified", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The time the activity was last modified", example="2021-07-01T12:00:00Z")
    private Instant lastModified;
    @NotNull
    @JsonProperty(value="actionType", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of action performed", example="startLaunch")
    private String actionType;
    @NotNull
    @JsonProperty(value="objectType", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The type of object on which the activity was performed", example="LAUNCH")
    private String objectType;
    @NotNull
    @JsonProperty(value="projectId", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the project in which the activity was performed", example="1")
    private Long projectId;
    @JsonProperty(value="projectName")
    @Schema(description="The name of the project in which the activity was performed", example="project")
    private String projectName;
    @JsonProperty(value="details")
    @Schema(description="The details of the activity, for example history of value", example="{\"history\": [{\"field\": \"status\", \"newValue\": \"FAILED\", \"oldValue\": \"PASSED\"}]}")
    private Object details;
    @JsonProperty(value="objectName")
    @Schema(description="The name of the object on which the activity was performed", example="Launch name")
    private String objectName;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public Long getLoggedObjectId() {
        return this.loggedObjectId;
    }

    @Generated
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getActionType() {
        return this.actionType;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public Long getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public Object getDetails() {
        return this.details;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @JsonProperty(value="id", required=true)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="user", required=true)
    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="loggedObjectId", required=true)
    @Generated
    public void setLoggedObjectId(Long loggedObjectId) {
        this.loggedObjectId = loggedObjectId;
    }

    @JsonProperty(value="lastModified", required=true)
    @Generated
    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    @JsonProperty(value="actionType", required=true)
    @Generated
    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @JsonProperty(value="objectType", required=true)
    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @JsonProperty(value="projectId", required=true)
    @Generated
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="projectName")
    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @JsonProperty(value="details")
    @Generated
    public void setDetails(Object details) {
        this.details = details;
    }

    @JsonProperty(value="objectName")
    @Generated
    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Generated
    public String toString() {
        return "ActivityResource(id=" + this.getId() + ", user=" + this.getUser() + ", loggedObjectId=" + this.getLoggedObjectId() + ", lastModified=" + String.valueOf(this.getLastModified()) + ", actionType=" + this.getActionType() + ", objectType=" + this.getObjectType() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", details=" + String.valueOf(this.getDetails()) + ", objectName=" + this.getObjectName() + ")";
    }

    @Generated
    public ActivityResource() {
    }
}

