/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.model;

import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;

public class Page<T>
implements Iterable<T> {
    private final Collection<T> content;
    private final PageMetadata page;

    Page() {
        this(null, null);
    }

    public Page(Collection<T> content, PageMetadata page) {
        this.content = content;
        this.page = page;
    }

    public Page(Collection<T> content, long size, long number, long totalElements, long totalPages) {
        this.content = content;
        this.page = new PageMetadata(size, number, totalElements, totalPages);
    }

    public Page(Collection<T> content, long size, long number, long totalElements) {
        this.content = content;
        this.page = new PageMetadata(size, number, totalElements);
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Page{");
        sb.append("content=").append(this.content);
        sb.append(", page=").append(this.page);
        sb.append('}');
        return sb.toString();
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Generated
    public Collection<T> getContent() {
        return this.content;
    }

    @Generated
    public PageMetadata getPage() {
        return this.page;
    }

    public static class PageMetadata {
        long number;
        long size;
        long totalElements;
        long totalPages;

        PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Page.checkArgument(size > -1L, "Size must not be negative!");
            Page.checkArgument(number > -1L, "Number must not be negative!");
            Page.checkArgument(totalElements > -1L, "Total elements must not be negative!");
            Page.checkArgument(totalPages > -1L, "Total pages must not be negative!");
            this.number = number;
            this.size = size;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : (long)Math.ceil((double)totalElements / (double)size));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PageMetadata{");
            sb.append("number=").append(this.number);
            sb.append(", size=").append(this.size);
            sb.append(", totalElements=").append(this.totalElements);
            sb.append(", totalPages=").append(this.totalPages);
            sb.append('}');
            return sb.toString();
        }

        @Generated
        public long getNumber() {
            return this.number;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public long getTotalElements() {
            return this.totalElements;
        }

        @Generated
        public long getTotalPages() {
            return this.totalPages;
        }
    }
}

