/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.model.validation;

import com.epam.ta.reportportal.ws.annotations.NotBlankWithSize;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class NotBlankWithSizeValidator
implements ConstraintValidator<NotBlankWithSize, String> {
    private static final String NOT_NULL_PROPERTY = "{NotNull}";
    private static final String NOT_BLANK_PROPERTY = "{NotBlank}";
    private static final String SIZE_PROPERTY = "{Size}";
    private static final String SPACE = " ";
    private int min;
    private int max;

    public void initialize(NotBlankWithSize notBlankWithSizeAnnotation) {
        this.min = notBlankWithSizeAnnotation.min();
        this.max = notBlankWithSizeAnnotation.max();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        boolean result;
        if (value == null) {
            result = false;
            this.setValidationMessage(NOT_NULL_PROPERTY, context);
        } else if (StringUtils.isBlank((CharSequence)value)) {
            result = false;
            String message = "{NotBlank} {Size}";
            this.setValidationMessage(message, context);
        } else if (value.length() < this.min || value.length() > this.max) {
            result = false;
            this.setValidationMessage(SIZE_PROPERTY, context);
        } else {
            result = true;
        }
        return result;
    }

    private void setValidationMessage(String message, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

