/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons;

import com.epam.reportportal.rules.commons.exception.message.ArgumentNotValidMessageBuilder;
import com.epam.reportportal.rules.commons.exception.message.DefaultExceptionMessageBuilder;
import com.epam.reportportal.rules.commons.exception.message.ExceptionMessageBuilder;
import com.epam.reportportal.rules.commons.exception.rest.RestErrorDefinition;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

public final class ExceptionMappings {
    private static final ReloadableResourceBundleMessageSource MESSAGE_SOURCE = new ReloadableResourceBundleMessageSource(){
        {
            this.setBasename("classpath:ValidationMessages");
            this.setDefaultEncoding("UTF-8");
        }
    };
    private static final ExceptionMessageBuilder<Exception> DEFAULT_MESSAGE_BUILDER = new DefaultExceptionMessageBuilder();
    public static Map<Class<? extends Throwable>, RestErrorDefinition> DEFAULT_MAPPING = ImmutableMap.builder().put(MethodArgumentNotValidException.class, new RestErrorDefinition<MethodArgumentNotValidException>(400, ErrorType.INCORRECT_REQUEST, new ArgumentNotValidMessageBuilder(MESSAGE_SOURCE))).put(HttpMessageNotReadableException.class, new RestErrorDefinition<Exception>(400, ErrorType.INCORRECT_REQUEST, DEFAULT_MESSAGE_BUILDER)).put(MissingServletRequestPartException.class, new RestErrorDefinition<Exception>(400, ErrorType.INCORRECT_REQUEST, DEFAULT_MESSAGE_BUILDER)).put(MissingServletRequestParameterException.class, new RestErrorDefinition<Exception>(400, ErrorType.INCORRECT_REQUEST, DEFAULT_MESSAGE_BUILDER)).put(AccessDeniedException.class, new RestErrorDefinition<Exception>(403, ErrorType.ACCESS_DENIED, DEFAULT_MESSAGE_BUILDER)).put(BadCredentialsException.class, new RestErrorDefinition<Exception>(401, ErrorType.ACCESS_DENIED, DEFAULT_MESSAGE_BUILDER)).put(LockedException.class, new RestErrorDefinition<Exception>(403, ErrorType.ADDRESS_LOCKED, DEFAULT_MESSAGE_BUILDER)).put(ReportPortalException.class, new RestErrorDefinition<Exception>(500, ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, DEFAULT_MESSAGE_BUILDER)).put(RestClientException.class, new RestErrorDefinition<Exception>(400, ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, DEFAULT_MESSAGE_BUILDER)).put(Throwable.class, new RestErrorDefinition<Exception>(500, ErrorType.UNCLASSIFIED_ERROR, DEFAULT_MESSAGE_BUILDER)).build();
}

