/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.exception.forwarding;

import com.epam.reportportal.rules.commons.exception.forwarding.ResponseForwardingException;
import com.google.common.io.ByteStreams;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class ClientResponseForwardingExceptionHandler
implements HandlerExceptionResolver,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientResponseForwardingExceptionHandler.class);
    private int order;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ResponseForwardingException.class.isAssignableFrom(ex.getClass())) {
            ModelAndView modelAndView;
            ResponseForwardingException forwardingException = (ResponseForwardingException)ex;
            ByteArrayInputStream dataStream = new ByteArrayInputStream(forwardingException.getBody());
            try {
                response.setStatus(forwardingException.getStatus().value());
                response.setContentType(forwardingException.getHeaders().getContentType().toString());
                ByteStreams.copy((InputStream)dataStream, (OutputStream)response.getOutputStream());
                modelAndView = new ModelAndView();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Cannot forward exception", (Throwable)e);
                    return null;
                }
            }
            dataStream.close();
            return modelAndView;
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

