/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.exception.rest;

import com.epam.reportportal.rules.commons.exception.rest.ErrorResolver;
import com.epam.reportportal.rules.commons.exception.rest.RestError;
import com.epam.reportportal.rules.commons.exception.rest.RestErrorDefinition;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorResolver
implements ErrorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultErrorResolver.class);
    private final Map<Class<? extends Throwable>, RestErrorDefinition> exceptionMappingDefinitions;

    public DefaultErrorResolver(Map<Class<? extends Throwable>, RestErrorDefinition> exceptionMappingDefinitions) {
        Preconditions.checkNotNull(exceptionMappingDefinitions, (Object)"Exceptions mappings should't be null");
        this.exceptionMappingDefinitions = exceptionMappingDefinitions;
    }

    @Override
    public RestError resolveError(Exception ex) {
        RestErrorDefinition errorDefinition = this.getRestErrorDefinition(ex);
        if (null == errorDefinition) {
            return null;
        }
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        RestError.Builder errorBuilder = new RestError.Builder();
        String message = Suppliers.formattedMessage(errorDefinition.getError().getDescription()) ? Suppliers.formattedSupplier(errorDefinition.getError().getDescription(), errorDefinition.getExceptionMessage(ex)).get() : errorDefinition.getError().getDescription() + " [" + errorDefinition.getExceptionMessage(ex) + "]";
        errorBuilder.setError(errorDefinition.getError()).setMessage(message).setStatus(errorDefinition.getHttpStatus());
        return errorBuilder.build();
    }

    private RestErrorDefinition getRestErrorDefinition(Exception ex) {
        Map<Class<? extends Throwable>, RestErrorDefinition> mappings = this.exceptionMappingDefinitions;
        if (mappings.isEmpty()) {
            return null;
        }
        RestErrorDefinition template = null;
        int deepest = Integer.MAX_VALUE;
        for (Map.Entry<Class<? extends Throwable>, RestErrorDefinition> entry : mappings.entrySet()) {
            Class<? extends Throwable> key = entry.getKey();
            int depth = this.getDepth(key, ex);
            if (depth < 0 || depth >= deepest) continue;
            deepest = depth;
            template = entry.getValue();
        }
        return template;
    }

    protected int getDepth(Class<? extends Throwable> exceptionMapping, Exception ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(Class<? extends Throwable> exceptionMapping, Class<?> exceptionClass, int depth) {
        if (exceptionClass.equals(exceptionMapping)) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }
}

