/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.exception.rest;

import com.epam.reportportal.rules.commons.exception.rest.RestErrorDefinition;
import com.epam.reportportal.rules.exception.ErrorRS;
import com.epam.reportportal.rules.exception.ErrorType;

public class ErrorResponseBuilder {
    private final RestErrorDefinition definition;
    private final ErrorType error;
    private String message;
    private String stackTrace;

    public ErrorResponseBuilder(RestErrorDefinition definition) {
        this.error = definition.getError();
        this.definition = definition;
    }

    public ErrorResponseBuilder setMessage(Exception ex) {
        this.message = this.definition.getExceptionMessage(ex);
        return this;
    }

    public ErrorResponseBuilder setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public ErrorRS build() {
        ErrorRS errorRS = new ErrorRS();
        errorRS.setMessage(this.message);
        errorRS.setStackTrace(this.stackTrace);
        errorRS.setErrorType(this.error);
        return errorRS;
    }
}

