/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.exception.rest;

import com.epam.reportportal.rules.commons.exception.rest.ErrorResolver;
import com.epam.reportportal.rules.commons.exception.rest.RestError;
import com.epam.reportportal.rules.commons.exception.rest.StatusCodeMapping;
import com.epam.reportportal.rules.exception.ReportPortalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ReportPortalExceptionResolver
implements ErrorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalExceptionResolver.class);
    private final ErrorResolver defaultErrorResolver;

    public ReportPortalExceptionResolver(ErrorResolver defaultErrorResolver) {
        this.defaultErrorResolver = defaultErrorResolver;
    }

    @Override
    public RestError resolveError(Exception ex) {
        LOGGER.error("ReportPortalExceptionResolver > {}", (Object)ex.getMessage(), (Object)ex);
        if (ReportPortalException.class.isAssignableFrom(ex.getClass())) {
            ReportPortalException currentException = (ReportPortalException)ex;
            RestError.Builder builder = new RestError.Builder();
            builder.setMessage(currentException.getMessage()).setStatus(StatusCodeMapping.getHttpStatus(currentException.getErrorType(), HttpStatus.INTERNAL_SERVER_ERROR)).setError(currentException.getErrorType());
            return builder.build();
        }
        return this.defaultErrorResolver.resolveError(ex);
    }
}

