/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.exception.rest;

import com.epam.reportportal.rules.commons.exception.rest.ErrorResolver;
import com.epam.reportportal.rules.commons.exception.rest.RestError;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.util.WebUtils;

public class RestExceptionHandler
extends DefaultHandlerExceptionResolver {
    private ErrorResolver errorResolver;
    private List<HttpMessageConverter<?>> messageConverters;

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Handled error: ", (Throwable)ex);
        ModelAndView defaultError = super.doResolveException(request, response, handler, ex);
        if (null != defaultError) {
            return defaultError;
        }
        return this.handleCustomException(request, response, ex);
    }

    protected ModelAndView handleCustomException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        RestError error = this.errorResolver.resolveError(ex);
        if (error == null) {
            return null;
        }
        this.applyStatusIfPossible(webRequest, error.httpStatus());
        try {
            return this.handleResponseBody(error.errorRS(), webRequest);
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Unable to write error message", (Throwable)e);
            }
            return null;
        }
    }

    private void applyStatusIfPossible(ServletWebRequest webRequest, HttpStatus status) {
        if (!WebUtils.isIncludeRequest((ServletRequest)webRequest.getRequest())) {
            webRequest.getResponse().setStatus(status.value());
        }
    }

    private ModelAndView handleResponseBody(Object body, ServletWebRequest webRequest) throws HttpMessageNotWritableException, IOException {
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(webRequest.getRequest());
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(webRequest.getResponse());
        Class<?> bodyType = body.getClass();
        List<HttpMessageConverter<?>> converters = this.messageConverters;
        if (converters != null) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                for (HttpMessageConverter<?> messageConverter : converters) {
                    if (!messageConverter.canWrite(bodyType, acceptedMediaType)) continue;
                    messageConverter.write(body, acceptedMediaType, (HttpOutputMessage)outputMessage);
                    return new ModelAndView();
                }
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not find HttpMessageConverter that supports return type [" + String.valueOf(bodyType) + "] and " + String.valueOf(acceptedMediaTypes)));
        }
        return null;
    }

    protected ModelAndView handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.handleCustomException(request, response, (Exception)ex);
    }

    protected ModelAndView handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.handleCustomException(request, response, (Exception)ex);
    }

    protected ModelAndView handleMissingServletRequestPartException(MissingServletRequestPartException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.handleCustomException(request, response, (Exception)ex);
    }

    protected ModelAndView handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.handleCustomException(request, response, (Exception)ex);
    }
}

