/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.validation;

import com.epam.reportportal.rules.commons.validation.BusinessRuleViolationException;
import com.epam.reportportal.rules.commons.validation.RuleValidator;
import com.epam.reportportal.rules.exception.ReportPortalException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultRuleValidator<T>
extends RuleValidator<T> {
    private final Supplier<String> message;

    public DefaultRuleValidator(T target, Predicate<T> predicate, Supplier<String> message) {
        super(target, predicate);
        this.message = message;
    }

    public void verify() throws BusinessRuleViolationException {
        if (!this.predicate.test(this.target)) {
            throw new BusinessRuleViolationException(this.message.get());
        }
    }

    public void verify(Class<? extends ReportPortalException> t) {
        if (!this.predicate.test(this.target)) {
            ReportPortalException toBeThrowed;
            try {
                toBeThrowed = t.getConstructor(String.class).newInstance(this.message.get());
            }
            catch (Exception e) {
                throw new ReportPortalException(this.message.get(), e);
            }
            throw toBeThrowed;
        }
    }
}

