/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.commons.validation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.function.Supplier;
import org.slf4j.helpers.MessageFormatter;

public class Suppliers {
    private static final CharMatcher REPLACEMENT_SYMBOLS = CharMatcher.anyOf((CharSequence)"{}");

    private Suppliers() {
    }

    public static Supplier<String> stringSupplier(String string) {
        return () -> string;
    }

    public static Supplier<String> formattedSupplier(final String string, final Object ... parameters) {
        return new Supplier<String>(){

            @Override
            public String get() {
                return Suppliers.clearPlaceholders(MessageFormatter.arrayFormat((String)string, (Object[])parameters).getMessage());
            }

            public String toString() {
                return this.get();
            }
        };
    }

    public static Supplier<String> formattedSupplier(final String string, final Supplier<?> ... parameters) {
        return new Supplier<String>(){

            @Override
            public String get() {
                return Suppliers.clearPlaceholders(MessageFormatter.arrayFormat((String)string, (Object[])Arrays.stream(parameters).map(Supplier::get).toArray()).getMessage());
            }

            public String toString() {
                return this.get();
            }
        };
    }

    @VisibleForTesting
    public static String clearPlaceholders(String message) {
        String cleared = message;
        if (Suppliers.formattedMessage(message)) {
            cleared = REPLACEMENT_SYMBOLS.removeFrom((CharSequence)message).trim();
        }
        return cleared;
    }

    public static boolean formattedMessage(String str) {
        return !Strings.isNullOrEmpty((String)str) && REPLACEMENT_SYMBOLS.matchesAnyOf((CharSequence)str);
    }

    public static String trimMessage(String message, int maxLength) {
        if (message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }
}

