/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.rules.exception;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;

public class ReportPortalException
extends RuntimeException {
    public static final int MAX_ERROR_MESSAGE_LENGTH = 10000;
    private static final long serialVersionUID = -7599195984281555977L;
    private ErrorType errorType;
    private Object[] parameters;

    public ReportPortalException(String message) {
        super(message);
    }

    public ReportPortalException(ErrorType errorType, Object ... parameters) {
        super(Suppliers.trimMessage(Suppliers.formattedSupplier(errorType.getDescription(), parameters).get(), 10000));
        this.errorType = errorType;
        this.parameters = parameters;
    }

    public ReportPortalException(String message, Throwable e) {
        super(Suppliers.trimMessage(message, 10000), e);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Object[] getParameters() {
        return this.parameters;
    }
}

