/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.log4j.appender;

import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.log4j.appender.Util;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class ReportPortalAppender
extends AppenderSkeleton {
    protected void append(LoggingEvent event) {
        if (null == event.getMessage()) {
            return;
        }
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ request = new SaveLogRQ();
            request.setLevel(event.getLevel().toString());
            request.setLogTime(new Date(event.getTimeStamp()));
            request.setItemUuid(itemUuid);
            String logMessage = null;
            try {
                ReportPortalMessage message = null;
                StringBuilder throwable = new StringBuilder();
                if (null != event.getThrowableInformation() && null != event.getThrowableInformation().getThrowable()) {
                    throwable.append(ExceptionUtils.getStackTrace((Throwable)event.getThrowableInformation().getThrowable()));
                }
                if (event.getMessage() instanceof ReportPortalMessage) {
                    message = (ReportPortalMessage)event.getMessage();
                } else if (event.getMessage() instanceof File) {
                    message = new ReportPortalMessage((File)event.getMessage(), "Binary data reported");
                } else if (event.getMessage() instanceof String && Util.MESSAGE_PARSER.supports((String)event.getMessage())) {
                    message = Util.MESSAGE_PARSER.parse((String)event.getMessage());
                }
                if (null != message && null != message.getData()) {
                    logMessage = message.getMessage();
                    SaveLogRQ.File file = new SaveLogRQ.File();
                    file.setContentType(message.getData().getMediaType());
                    file.setContent(message.getData().read());
                    file.setName(UUID.randomUUID().toString());
                    request.setFile(file);
                } else {
                    Layout myLayout = this.getLayout();
                    if (myLayout == null) {
                        logMessage = event.getRenderedMessage();
                    } else {
                        if (myLayout instanceof PatternLayout) {
                            myLayout = new PatternLayout(((PatternLayout)myLayout).getConversionPattern());
                        }
                        logMessage = myLayout.format(event).concat(throwable.toString());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            request.setMessage(logMessage);
            return request;
        });
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

