/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.logback.appender.classic;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.epam.reportportal.guice.Injector;
import com.epam.reportportal.listeners.ReportPortalListenerContext;
import com.epam.reportportal.logback.appender.IAppenderService;
import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.BatchedReportPortalService;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.io.ByteSource;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicAppenderService
implements IAppenderService {
    private final Logger logger = LoggerFactory.getLogger(ClassicAppenderService.class);
    private BatchedReportPortalService reportPortalService = (BatchedReportPortalService)Injector.getInstance().getBean(BatchedReportPortalService.class);
    private MessageParser messageParser = (MessageParser)Injector.getInstance().getBean(MessageParser.class);
    private boolean shouldConvertImage;

    public ClassicAppenderService() {
        String isConvertProperty = Injector.getInstance().getProperty(ListenerProperty.IS_CONVERT_IMAGE);
        this.shouldConvertImage = Boolean.parseBoolean(isConvertProperty == null ? "false" : isConvertProperty);
    }

    @Override
    public void processEvent(ILoggingEvent event, PatternLayoutEncoder encoder) {
        String currentItemId = ReportPortalListenerContext.getRunningNowItemId();
        if (null == currentItemId) {
            return;
        }
        ReportPortalMessage message = null;
        if (this.messageParser.supports(event.getFormattedMessage())) {
            message = this.messageParser.parse(event.getFormattedMessage());
        }
        String text = null == message ? encoder.getLayout().doLayout((Object)event) : message.getMessage();
        SaveLogRQ saveLogRQ = this.buildSaveLogRQ(new Date(event.getTimeStamp()), currentItemId, text, event.getLevel().toString(), message == null ? null : message.getData());
        this.saveLogToRP(saveLogRQ);
    }

    private void saveLogToRP(SaveLogRQ saveLogRQ) {
        try {
            this.reportPortalService.log(saveLogRQ);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to send log message to Report Portal.", (Throwable)e);
        }
    }

    private SaveLogRQ buildSaveLogRQ(Date time, String currentItemId, String message, String level, ByteSource content) {
        SaveLogRQ saveLogRQ = new SaveLogRQ();
        saveLogRQ.setMessage(message);
        saveLogRQ.setLogTime(time);
        saveLogRQ.setTestItemId(currentItemId);
        saveLogRQ.setLevel(level);
        if (null != content) {
            SaveLogRQ.File file = new SaveLogRQ.File();
            file.setName(UUID.randomUUID().toString());
            file.setContent(this.shouldConvertImage ? ImageConverter.convertIfImage((ByteSource)content) : content);
            saveLogRQ.setFile(file);
        }
        return saveLogRQ;
    }
}

