/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.logback.appender;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.epam.reportportal.message.HashMarkSeparatedMessageParser;
import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import rp.com.google.common.base.Function;

public class ReportPortalAppender
extends AppenderBase<ILoggingEvent> {
    private static final MessageParser MESSAGE_PARSER = new HashMarkSeparatedMessageParser();
    private PatternLayoutEncoder encoder;

    protected void append(final ILoggingEvent event) {
        ReportPortal.emitLog((Function)new Function<String, SaveLogRQ>(){

            public SaveLogRQ apply(@Nullable String itemId) {
                String message = event.getFormattedMessage();
                String level = event.getLevel().toString();
                Date time = new Date(event.getTimeStamp());
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(itemId);
                try {
                    if (MESSAGE_PARSER.supports(message)) {
                        ReportPortalMessage rpMessage = MESSAGE_PARSER.parse(message);
                        TypeAwareByteSource data = rpMessage.getData();
                        SaveLogRQ.File file = new SaveLogRQ.File();
                        file.setContent(data.read());
                        file.setContentType(data.getMediaType());
                        file.setName(UUID.randomUUID().toString());
                        rq.setFile(file);
                        rq.setMessage(rpMessage.getMessage());
                    } else {
                        rq.setMessage(ReportPortalAppender.this.encoder.getLayout().doLayout((Object)event));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return rq;
            }
        });
    }

    public void start() {
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        this.encoder.start();
        super.start();
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }
}

