/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.logback.appender;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.epam.reportportal.message.HashMarkSeparatedMessageParser;
import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.logs.LoggingSubscriber;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class ReportPortalAppender
extends AppenderBase<ILoggingEvent> {
    private static final MessageParser MESSAGE_PARSER = new HashMarkSeparatedMessageParser();
    private static final List<String> LOGGING_ISSUE = Collections.singletonList(LoggingSubscriber.class.getCanonicalName());
    private PatternLayoutEncoder encoder;

    protected void append(ILoggingEvent event) {
        String loggerName = event.getLoggerName();
        for (String packagePrefix : LOGGING_ISSUE) {
            if (!loggerName.startsWith(packagePrefix)) continue;
            return;
        }
        ReportPortal.emitLog(itemUuid -> {
            String message = event.getFormattedMessage();
            String level = event.getLevel().toString();
            Date time = new Date(event.getTimeStamp());
            SaveLogRQ request = new SaveLogRQ();
            request.setLevel(level);
            request.setLogTime(time);
            request.setItemUuid(itemUuid);
            try {
                if (MESSAGE_PARSER.supports(message)) {
                    ReportPortalMessage rpMessage = MESSAGE_PARSER.parse(message);
                    TypeAwareByteSource data = rpMessage.getData();
                    SaveLogRQ.File file = new SaveLogRQ.File();
                    file.setContent(data.read());
                    file.setContentType(data.getMediaType());
                    file.setName(UUID.randomUUID().toString());
                    request.setFile(file);
                    request.setMessage(rpMessage.getMessage());
                } else {
                    request.setMessage(this.encoder.getLayout().doLayout((Object)event));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return request;
        });
    }

    public void start() {
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        this.encoder.start();
        super.start();
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }
}

