/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.selenide;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class ReportPortalSelenideEventListener
implements LogEventListener {
    public static final Function<String, String> DEFAULT_STEP_NAME_CONVERTER = log -> log;
    private static final String SCREENSHOT_MESSAGE = "Screenshot";
    private static final String PAGE_SOURCE_MESSAGE = "Page source";
    private static final String SELENIUM_LOG_MESSAGE_PATTERN = "WebDriver logs of '%s' type";
    private static final String SELENIUM_SCREENSHOT_TYPE = "image/png";
    private static final String SELENIUM_PAGE_SOURCE_TYPE = "text/html";
    private static final String SELENIUM_LOG_TYPE = "text/plain";
    private final String logLevel;
    private final Function<String, String> converter;
    private final Map<String, Level> seleniumLogTypes = new HashMap<String, Level>();
    private final Set<Class<? extends LogEvent>> selenideLogTypes = new HashSet<Class<SelenideLog>>(Collections.singleton(SelenideLog.class));
    private boolean screenshots = true;
    private boolean pageSources = true;

    public ReportPortalSelenideEventListener(@Nonnull LogLevel defaultLogLevel, Function<String, String> stepConverter) {
        this.logLevel = defaultLogLevel.name();
        this.converter = stepConverter;
    }

    public ReportPortalSelenideEventListener(@Nonnull LogLevel defaultLogLevel) {
        this(defaultLogLevel, DEFAULT_STEP_NAME_CONVERTER);
    }

    public ReportPortalSelenideEventListener() {
        this(LogLevel.INFO);
    }

    public ReportPortalSelenideEventListener logScreenshots(boolean logScreenshots) {
        this.screenshots = logScreenshots;
        return this;
    }

    public ReportPortalSelenideEventListener logPageSources(boolean logPageSources) {
        this.pageSources = logPageSources;
        return this;
    }

    public ReportPortalSelenideEventListener enableSeleniumLogs(@Nonnull String logType, @Nonnull Level logLevel) {
        this.seleniumLogTypes.put(logType, logLevel);
        return this;
    }

    public ReportPortalSelenideEventListener disableSeleniumLogs(@Nonnull String logType) {
        this.seleniumLogTypes.remove(logType);
        return this;
    }

    public ReportPortalSelenideEventListener enableSelenideLogs(@Nonnull Class<? extends LogEvent> selenideLogType) {
        this.selenideLogTypes.add(selenideLogType);
        return this;
    }

    public ReportPortalSelenideEventListener disableSelenideLogs(@Nonnull Class<? extends LogEvent> selenideLogType) {
        this.selenideLogTypes.remove(selenideLogType);
        return this;
    }

    private boolean skip(LogEvent currentLog) {
        return !this.selenideLogTypes.contains(currentLog.getClass());
    }

    public void beforeEvent(@Nonnull LogEvent currentLog) {
        if (this.skip(currentLog)) {
            return;
        }
        Optional.ofNullable(Launch.currentLaunch()).ifPresent(l -> l.getStepReporter().sendStep(ItemStatus.INFO, this.converter.apply(currentLog.toString())));
    }

    private void attachBinary(@Nonnull String message, @Nonnull byte[] attachment, @Nonnull String type) {
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])attachment), type, message), (String)this.logLevel, (Date)Calendar.getInstance().getTime());
    }

    private void logScreenshot() {
        if (WebDriverRunner.hasWebDriverStarted()) {
            try {
                byte[] screenshot = (byte[])((TakesScreenshot)WebDriverRunner.getWebDriver()).getScreenshotAs(OutputType.BYTES);
                if (screenshot != null) {
                    this.attachBinary(SCREENSHOT_MESSAGE, screenshot, SELENIUM_SCREENSHOT_TYPE);
                }
            }
            catch (Exception e) {
                ReportPortal.emitLog((String)("Unable to get WebDriver screenshot: " + e.getMessage()), (String)LogLevel.ERROR.name(), (Date)Calendar.getInstance().getTime());
            }
        }
    }

    private void logPageSource() {
        if (WebDriverRunner.hasWebDriverStarted()) {
            try {
                String pageSource = WebDriverRunner.getWebDriver().getPageSource();
                if (pageSource != null) {
                    this.attachBinary(PAGE_SOURCE_MESSAGE, pageSource.getBytes(StandardCharsets.UTF_8), SELENIUM_PAGE_SOURCE_TYPE);
                }
            }
            catch (Exception e) {
                ReportPortal.emitLog((String)("Unable to get WebDriver page source: " + e.getMessage()), (String)LogLevel.ERROR.name(), (Date)Calendar.getInstance().getTime());
            }
        }
    }

    private static String getBrowserLogs(@Nonnull String logType, @Nonnull Level level) {
        return String.join((CharSequence)"\n\n", Selenide.getWebDriverLogs((String)logType, (Level)level));
    }

    public void afterEvent(@Nonnull LogEvent currentLog) {
        if (this.skip(currentLog)) {
            return;
        }
        if (LogEvent.EventStatus.FAIL.equals((Object)currentLog.getStatus())) {
            if (this.screenshots) {
                this.logScreenshot();
            }
            if (this.pageSources) {
                this.logPageSource();
            }
            this.seleniumLogTypes.forEach((k, v) -> {
                String logs = ReportPortalSelenideEventListener.getBrowserLogs(k, v);
                this.attachBinary(String.format(SELENIUM_LOG_MESSAGE_PATTERN, k), logs.getBytes(StandardCharsets.UTF_8), SELENIUM_LOG_TYPE);
            });
            Optional.ofNullable(Launch.currentLaunch()).ifPresent(l -> l.getStepReporter().finishPreviousStep(ItemStatus.FAILED));
        } else if (LogEvent.EventStatus.PASS.equals((Object)currentLog.getStatus())) {
            Optional.ofNullable(Launch.currentLaunch()).ifPresent(l -> l.getStepReporter().finishPreviousStep());
        } else {
            ReportPortal.emitLog((String)("Unable to process selenide event status, skipping it: " + currentLog.getStatus()), (String)LogLevel.WARN.name(), (Date)Calendar.getInstance().getTime());
            Optional.ofNullable(Launch.currentLaunch()).ifPresent(l -> l.getStepReporter().finishPreviousStep(ItemStatus.WARN));
        }
    }
}

