/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import com.epam.ta.reportportal.auth.ExpirationPolicy;
import com.epam.ta.reportportal.database.Time;
import com.epam.ta.reportportal.database.entity.user.User;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LoginTimeBasedExpirationPolicy
implements ExpirationPolicy {
    private Time time;

    public LoginTimeBasedExpirationPolicy(Time time) {
        this.time = time;
    }

    @Autowired
    public LoginTimeBasedExpirationPolicy(@Value(value="${rp.auth.expire.account.after}") long expirationDays) {
        this.time = Time.days((long)expirationDays);
    }

    public Date getExpirationDate() {
        return DateUtils.addSeconds((Date)Calendar.getInstance().getTime(), (int)((int)(-1L * this.time.in(TimeUnit.SECONDS))));
    }

    public boolean isExpired(User user) {
        return user.getMetaInfo().getLastLogin().before(this.getExpirationDate());
    }
}

