/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.acl.chain;

import com.epam.ta.reportportal.core.acl.chain.ChainElement;
import com.epam.ta.reportportal.core.acl.chain.IChainElement;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="WidgetChainElement")
public class WidgetChainElement
extends ChainElement {
    @Autowired
    private UserFilterRepository userFilterRepository;
    @Autowired
    private WidgetRepository widgetRepository;

    @Autowired
    public WidgetChainElement(@Qualifier(value="UserFilterChainElement") IChainElement nextChainElement) {
        super(nextChainElement);
    }

    public boolean isCanHandle(List<? extends Shareable> elementsToProcess) {
        return Widget.class.equals(elementsToProcess.get(0).getClass());
    }

    public List<? extends Shareable> getNextElements(List<? extends Shareable> elementsToProcess, String ownerId) {
        HashSet<String> ids = new HashSet<String>();
        for (Shareable shareable : elementsToProcess) {
            Widget widget = (Widget)shareable;
            ids.add(widget.getApplyingFilterId());
        }
        return this.userFilterRepository.findOnlyOwnedEntities(ids, ownerId);
    }

    public void saveElements(List<? extends Shareable> elementsToProcess) {
        this.widgetRepository.save((Iterable)elementsToProcess.stream().map(input -> (Widget)input).collect(Collectors.toList()));
    }
}

