/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.admin;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.database.entity.ServerSettings;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.ServerSettingsResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailConfig;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import com.epam.ta.reportportal.ws.model.settings.UpdateEmailSettingsRQ;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.mail.MessagingException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerAdminHandlerImpl
implements ServerAdminHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAdminHandlerImpl.class);
    @Autowired
    private BasicTextEncryptor simpleEncryptor;
    @Autowired
    private ServerSettingsRepository repository;
    @Autowired
    private ServerSettingsResourceAssembler settingsAssembler;
    @Autowired
    private MailServiceFactory emailServiceFactory;

    public ServerSettingsResource getServerSettings(String profileId) {
        ServerSettings settings = (ServerSettings)this.repository.findOne((Serializable)((Object)profileId));
        BusinessRule.expect((Object)settings, (Predicate)Predicates.notNull()).verify(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{profileId});
        return this.settingsAssembler.toResource(settings);
    }

    public OperationCompletionRS saveEmailSettings(String profileId, UpdateEmailSettingsRQ request) {
        ServerSettings settings = (ServerSettings)this.repository.findOne((Serializable)((Object)profileId));
        BusinessRule.expect((Object)settings, (Predicate)Predicates.notNull()).verify(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{profileId});
        if (null != request) {
            ServerEmailConfig serverEmailConfig = settings.getServerEmailConfig();
            if (request.getDebug()) {
                serverEmailConfig.setDebug(request.getDebug());
            }
            if (null != request.getHost()) {
                serverEmailConfig.setHost(request.getHost());
            }
            if (null != request.getPort()) {
                try {
                    int port = Integer.parseInt(request.getPort());
                    if (port <= 0 || port > 65535) {
                        BusinessRule.fail().withError(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect 'Port' value. Allowed value is [1..65535]"});
                    }
                    serverEmailConfig.setPort(port);
                }
                catch (NumberFormatException e) {
                    BusinessRule.fail().withError(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect 'Port' value. Allowed value is [1..65535]"});
                }
            }
            if (null != request.getProtocol()) {
                serverEmailConfig.setProtocol(request.getProtocol());
            }
            if (request.getAuthEnabled()) {
                serverEmailConfig.setAuthEnabled(Boolean.valueOf(request.getAuthEnabled()));
                if (null != request.getUsername()) {
                    serverEmailConfig.setUsername(request.getUsername());
                }
                if (null != request.getPassword()) {
                    serverEmailConfig.setPassword(this.simpleEncryptor.encrypt(request.getPassword()));
                }
            } else {
                serverEmailConfig.setAuthEnabled(Boolean.valueOf(false));
                serverEmailConfig.setUsername(null);
                serverEmailConfig.setPassword(null);
            }
            serverEmailConfig.setStarTlsEnabled(Boolean.TRUE.equals(request.getStarTlsEnabled()));
            serverEmailConfig.setSslEnabled(Boolean.TRUE.equals(request.getSslEnabled()));
            try {
                this.emailServiceFactory.getEmailService(serverEmailConfig, false).testConnection();
            }
            catch (MessagingException ex) {
                LOGGER.error("Cannot send email to user", (Throwable)ex);
                BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Email configuration is incorrect. Please, check your configuration. " + ex.getMessage()});
            }
        }
        this.repository.save((Object)settings);
        return new OperationCompletionRS("Server Settings with profile '" + profileId + "' is successfully updated.");
    }
}

