/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.commons.ExceptionMappings;
import com.epam.ta.reportportal.commons.exception.forwarding.ClientResponseForwardingExceptionHandler;
import com.epam.ta.reportportal.commons.exception.rest.DefaultErrorResolver;
import com.epam.ta.reportportal.commons.exception.rest.ErrorResolver;
import com.epam.ta.reportportal.commons.exception.rest.ReportPortalExceptionResolver;
import com.epam.ta.reportportal.commons.exception.rest.RestExceptionHandler;
import com.epam.ta.reportportal.ws.resolver.ActiveUserWebArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.FilterCriteriaResolver;
import com.epam.ta.reportportal.ws.resolver.JsonViewSupportFactoryBean;
import com.epam.ta.reportportal.ws.resolver.PagingHandlerMethodArgumentResolver;
import com.epam.ta.reportportal.ws.resolver.SortArgumentResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.validation.beanvalidation.BeanValidationPostProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MvcConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private List<HttpMessageConverter<?>> converters;
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/public/", "classpath:/META-INF/resources/", "classpath:/resources/"};

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!registry.hasMappingForPattern("/**")) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(CLASSPATH_RESOURCE_LOCATIONS);
        }
        if (!registry.hasMappingForPattern("/webjars/**")) {
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.htm");
        registry.setOrder(Integer.MIN_VALUE);
    }

    @Bean
    public SortArgumentResolver sortArgumentResolver() {
        SortArgumentResolver argumentResolver = new SortArgumentResolver();
        argumentResolver.setSortParameter("page.sort");
        argumentResolver.setQualifierDelimiter("+");
        return argumentResolver;
    }

    @Bean
    public JsonViewSupportFactoryBean jsonViewSupportFactoryBean() {
        return new JsonViewSupportFactoryBean();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.clear();
        PagingHandlerMethodArgumentResolver pageableResolver = new PagingHandlerMethodArgumentResolver((SortHandlerMethodArgumentResolver)this.sortArgumentResolver());
        pageableResolver.setPrefix("page.");
        pageableResolver.setOneIndexedParameters(true);
        argumentResolvers.add((HandlerMethodArgumentResolver)pageableResolver);
        argumentResolvers.add((HandlerMethodArgumentResolver)new ActiveUserWebArgumentResolver());
        argumentResolvers.add((HandlerMethodArgumentResolver)new FilterCriteriaResolver());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        converters.add((HttpMessageConverter<?>)this.jsonConverter());
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ClientResponseForwardingExceptionHandler forwardingExceptionHandler = new ClientResponseForwardingExceptionHandler();
        forwardingExceptionHandler.setOrder(Integer.MIN_VALUE);
        exceptionResolvers.add((HandlerExceptionResolver)forwardingExceptionHandler);
        RestExceptionHandler handler = new RestExceptionHandler();
        handler.setOrder(-2147483647);
        DefaultErrorResolver defaultErrorResolver = new DefaultErrorResolver(ExceptionMappings.DEFAULT_MAPPING);
        handler.setErrorResolver((ErrorResolver)new ReportPortalExceptionResolver((ErrorResolver)defaultErrorResolver));
        handler.setMessageConverters(Collections.singletonList(this.jsonConverter()));
        exceptionResolvers.add((HandlerExceptionResolver)handler);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false);
    }

    @Bean
    public BeanValidationPostProcessor beanValidationPostProcessor() {
        return new BeanValidationPostProcessor();
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        return new MappingJackson2HttpMessageConverter(this.objectMapper);
    }

    @Bean
    HttpMessageConverters httpMessageConverters() {
        return new HttpMessageConverters((Collection)this.converters);
    }

    @Bean
    public CommonsMultipartResolver multipartResolver() {
        return new CommonsMultipartResolver();
    }
}

