/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.dashboard.IDeleteDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteDashboardHandler
implements IDeleteDashboardHandler {
    @Autowired
    private DashboardRepository dashboardRepository;

    public OperationCompletionRS deleteDashboard(String dashboardId, String userName, String projectName) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
        BusinessRule.expect((Object)dashboard, (Predicate)Predicates.notNull()).verify(ErrorType.DASHBOARD_NOT_FOUND, new Object[]{dashboardId});
        AclUtils.validateOwner((Acl)dashboard.getAcl(), (String)userName, (String)dashboard.getName());
        BusinessRule.expect((Object)dashboard.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        try {
            this.dashboardRepository.delete((Serializable)((Object)dashboardId));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting dashboard item", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        StringBuilder msg = new StringBuilder("Dashboard with ID = '");
        msg.append(dashboardId);
        msg.append("' successfully deleted.");
        response.setResultMessage(msg.toString());
        return response;
    }
}

