/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.dashboard.IGetDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.FavoriteResourceRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.favorite.FavoriteResource;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.ws.converter.DashboardResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.ws.model.favorites.FavoriteResourceTypes;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class GetDashboardHandler
implements IGetDashboardHandler {
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private DashboardResourceAssembler resourceAssembler;
    @Autowired
    private FavoriteResourceRepository favoriteResourceRepository;
    private final Sort creationDateSort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "creationDate")});

    public DashboardResource getDashboard(String dashboardId, String userName, String projectName) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
        BusinessRule.expect((Object)dashboard, (Predicate)Predicates.notNull()).verify(ErrorType.DASHBOARD_NOT_FOUND, new Object[]{dashboardId});
        AclUtils.isPossibleToRead((Acl)dashboard.getAcl(), (String)userName, (String)projectName);
        BusinessRule.expect((Object)dashboard.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        return this.resourceAssembler.toResource(dashboard);
    }

    public Iterable<DashboardResource> getAllDashboards(String userName, String projectName) {
        List favoriteResources = this.favoriteResourceRepository.findByFilter(this.getFavoriteDashboardsFilter(userName, projectName));
        List favoriteDashboardsIds = favoriteResources.stream().map(FavoriteResource::getResourceId).collect(Collectors.toList());
        Iterable favoriteDashboars = this.dashboardRepository.findAll(favoriteDashboardsIds);
        List dashboards = this.dashboardRepository.findAll(userName, this.creationDateSort, projectName);
        dashboards.addAll(Lists.newArrayList((Iterable)favoriteDashboars));
        this.addRemovedDashboards(favoriteDashboardsIds, dashboards);
        return this.resourceAssembler.toResources((Iterable)dashboards);
    }

    public Map<String, SharedEntity> getSharedDashboardsNames(String ownerName, String projectName) {
        List dashboards = this.dashboardRepository.findSharedEntities(ownerName, projectName, (List)Lists.newArrayList((Object[])new String[]{"_id", "name", "acl.ownerUserId"}), Shareable.NAME_OWNER_SORT);
        return this.toMap(dashboards);
    }

    private void addRemovedDashboards(List<String> ids, List<Dashboard> dashboards) {
        if (Preconditions.NOT_EMPTY_COLLECTION.test(ids) && Preconditions.NOT_EMPTY_COLLECTION.test(dashboards)) {
            Set dashHashSet = dashboards.stream().map(Dashboard::getId).collect(Collectors.toSet());
            List additionalDashboards = ids.stream().filter(id -> !dashHashSet.contains(id)).map(id -> {
                Dashboard dashboard = new Dashboard();
                dashboard.setId(id);
                return dashboard;
            }).collect(Collectors.toList());
            dashboards.addAll(additionalDashboards);
        }
    }

    private Map<String, SharedEntity> toMap(List<Dashboard> dashboards) {
        LinkedHashMap<String, SharedEntity> result = new LinkedHashMap<String, SharedEntity>();
        for (Dashboard dashboard : dashboards) {
            SharedEntity sharedEntity = new SharedEntity();
            sharedEntity.setName(dashboard.getName());
            if (null != dashboard.getAcl()) {
                sharedEntity.setOwner(dashboard.getAcl().getOwnerUserId());
            }
            result.put(dashboard.getId(), sharedEntity);
        }
        return result;
    }

    private Filter getFavoriteDashboardsFilter(String userName, String projectName) {
        FilterCondition resourceTypeCondition = new FilterCondition(Condition.EQUALS, false, FavoriteResourceTypes.DASHBOARD.name(), "resourceType");
        FilterCondition userNameCondition = new FilterCondition(Condition.EQUALS, false, userName, "userName");
        FilterCondition projectCondition = new FilterCondition(Condition.EQUALS, false, projectName, "projectName");
        return new Filter(FavoriteResource.class, (Set)Sets.newHashSet((Object[])new FilterCondition[]{resourceTypeCondition, userNameCondition, projectCondition}));
    }
}

