/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.dashboard.IUpdateDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.events.DashboardUpdatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateDashboardHandler
implements IUpdateDashboardHandler {
    public static final int WIDGETS_LIMIT = 20;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private SharingService sharingService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public OperationCompletionRS updateDashboard(UpdateDashboardRQ rq, String dashboardId, String userName, String projectName) {
        Widget widget;
        StringBuilder additionalInfo = new StringBuilder();
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
        BusinessRule.expect((Object)dashboard, (Predicate)Predicates.notNull()).verify(ErrorType.DASHBOARD_NOT_FOUND, new Object[]{dashboardId});
        AclUtils.validateOwner((Acl)dashboard.getAcl(), (String)userName, (String)dashboard.getName());
        BusinessRule.expect((Object)dashboard.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        if (null != rq.getName()) {
            Dashboard isExist = this.dashboardRepository.findOneByUserProject(userName, projectName, rq.getName());
            if (isExist != null && !dashboardId.equalsIgnoreCase(isExist.getId())) {
                BusinessRule.fail().withError(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
            }
            dashboard.setName(rq.getName().trim());
        }
        BusinessRule.expect((Object)(null != rq.getAddWidget() && null != rq.getDeleteWidgetId() && rq.getDeleteWidgetId().equalsIgnoreCase(rq.getAddWidget().getWidgetId()) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{"Unable delete and add the same widget simmulteniuosly."});
        if (null != rq.getWidgets()) {
            ArrayList<Dashboard.WidgetObject> update = new ArrayList<Dashboard.WidgetObject>();
            for (Dashboard.WidgetObject widget2 : dashboard.getWidgets()) {
                rq.getWidgets().stream().filter(updWidget -> widget2.getWidgetId().equalsIgnoreCase(updWidget.getWidgetId())).forEach(updWidget -> {
                    if (null != updWidget.getWidgetPosition()) {
                        widget2.setWidgetPosition(updWidget.getWidgetPosition());
                    }
                    if (null != updWidget.getWidgetSize()) {
                        widget2.setWidgetSize(updWidget.getWidgetSize());
                    }
                });
                update.add(widget2);
            }
            dashboard.setWidgets(update);
        }
        if (null != rq.getAddWidget()) {
            widget = (Widget)this.widgetRepository.findOneLoadACL((Serializable)((Object)rq.getAddWidget().getWidgetId()));
            this.validateAddingWidget(dashboard.getWidgets(), widget, rq.getAddWidget().getWidgetId(), userName, projectName);
            if (null == rq.getAddWidget().getWidgetPosition() || rq.getAddWidget().getWidgetPosition().size() < 2) {
                ArrayList<Integer> widgetPosition = new ArrayList<Integer>();
                int yPosition = 0;
                int xPosition = 0;
                List widgets = dashboard.getWidgets();
                for (Dashboard.WidgetObject widgetObject : widgets) {
                    if (widgetObject.getWidgetPosition().size() <= 1 || (Integer)widgetObject.getWidgetPosition().get(1) <= yPosition) continue;
                    yPosition = (Integer)widgetObject.getWidgetPosition().get(1);
                }
                widgetPosition.add(xPosition);
                widgetPosition.add(++yPosition);
                rq.getAddWidget().setWidgetPosition(widgetPosition);
            }
            dashboard.getWidgets().add(new Dashboard.WidgetObject(widget.getId(), rq.getAddWidget().getWidgetSize(), rq.getAddWidget().getWidgetPosition()));
            if (!dashboard.getAcl().getEntries().isEmpty() && widget.getAcl().getEntries().isEmpty()) {
                this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Dashboard[]{dashboard}), userName, projectName, true);
                additionalInfo.append("Widget '");
                additionalInfo.append(rq.getAddWidget().getWidgetId());
                additionalInfo.append("' has been shared for project cause shared dashboard.");
            }
        }
        if (null != rq.getDeleteWidgetId()) {
            BusinessRule.expect((Object)this.processWidgets(dashboard.getWidgets(), rq.getDeleteWidgetId(), true), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.WIDGET_NOT_FOUND_IN_DASHBOARD, new Object[]{rq.getDeleteWidgetId(), dashboardId});
            widget = (Widget)this.widgetRepository.findOneLoadACL((Serializable)((Object)rq.getDeleteWidgetId()));
            if (null != widget && widget.getAcl().getOwnerUserId().equals(userName)) {
                try {
                    this.widgetRepository.delete((Serializable)((Object)rq.getDeleteWidgetId()));
                }
                catch (Exception e) {
                    throw new ReportPortalException("Error during deleting widget", (Throwable)e);
                }
            } else {
                Iterator iterator = dashboard.getWidgets().iterator();
                while (iterator.hasNext()) {
                    if (!((Dashboard.WidgetObject)iterator.next()).getWidgetId().equals(rq.getDeleteWidgetId())) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        if (null != rq.getShare()) {
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Dashboard[]{dashboard}), userName, projectName, rq.getShare().booleanValue());
        }
        this.dashboardRepository.save((Object)dashboard);
        this.eventPublisher.publishEvent((Object)new DashboardUpdatedEvent(dashboard, rq, userName));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboard.getId() + "' successfully updated." + additionalInfo.toString());
    }

    private void validateAddingWidget(List<Dashboard.WidgetObject> allWidgets, Widget widgetFromDB, String widgetId, String userName, String projectName) {
        BusinessRule.expect((Object)widgetFromDB, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        BusinessRule.expect((Object)widgetFromDB.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to add widget from another project"});
        BusinessRule.expect((Object)(allWidgets.size() == 20 ? 1 : 0), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to add more than '{}' widgets to dashboard.", (Object[])new Object[]{20})});
        BusinessRule.expect((Object)this.processWidgets(allWidgets, widgetId, false), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Widget with ID '{}' already added to the current dashboard.", (Object[])new Object[]{widgetId})});
        AclUtils.isPossibleToRead((Acl)widgetFromDB.getAcl(), (String)userName, (String)projectName);
    }

    private boolean processWidgets(List<Dashboard.WidgetObject> widgets, String searchingId, boolean isRemove) {
        Iterator<Dashboard.WidgetObject> iterator = widgets.iterator();
        boolean isFound = false;
        while (iterator.hasNext()) {
            Dashboard.WidgetObject widget = iterator.next();
            if (!widget.getWidgetId().equalsIgnoreCase(searchingId)) continue;
            if (isRemove) {
                iterator.remove();
            }
            isFound = true;
            break;
        }
        return isFound;
    }
}

