/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.favorites.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.favorites.IAddToFavoritesHandler;
import com.epam.ta.reportportal.core.favorites.impl.Utils;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.FavoriteResourceRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.ReportPortalRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.favorite.FavoriteResource;
import com.epam.ta.reportportal.database.entity.sharing.AclPermissions;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.converter.DashboardResourceAssembler;
import com.epam.ta.reportportal.ws.converter.builders.FavoriteResourceBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.ws.model.favorites.AddFavoriteResourceRQ;
import com.epam.ta.reportportal.ws.model.favorites.FavoriteResourceTypes;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AddToFavoritesHandler
implements IAddToFavoritesHandler {
    @Autowired
    private FavoriteResourceRepository favoriteResourceRepository;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private DashboardResourceAssembler resourceAssembler;
    @Resource(name="favoritesRepositories")
    private Map<FavoriteResourceTypes, ReportPortalRepository<? extends Shareable, String>> repositories;
    @Autowired
    @Qualifier(value="favoriteResourceBuilder.reference")
    private LazyReference<FavoriteResourceBuilder> favoriteResourceBuilder;

    public DashboardResource add(AddFavoriteResourceRQ addFavoriteResourceRQ, String userName, String projectName) {
        this.validate(addFavoriteResourceRQ, userName, projectName);
        FavoriteResource favoriteResource = (FavoriteResource)((FavoriteResourceBuilder)this.favoriteResourceBuilder.get()).addProject(projectName).addUser(userName).addCreateRQ(addFavoriteResourceRQ).build();
        this.favoriteResourceRepository.save((Object)favoriteResource);
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)addFavoriteResourceRQ.getResourceId()));
        return this.resourceAssembler.toResource(dashboard);
    }

    private void validate(AddFavoriteResourceRQ addFavoriteResourceRQ, String userName, String projectName) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Project.UserConfig assigned = (Project.UserConfig)project.getUsers().get(userName);
        BusinessRule.expect((Object)assigned, (Predicate)Predicates.notNull()).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"User '{}' not assigned to target project", (Object[])new Object[]{userName})});
        ReportPortalRepository repository = (ReportPortalRepository)this.repositories.get(addFavoriteResourceRQ.getType());
        BusinessRule.expect((Object)repository, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_ADD_TO_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"Unknown resource type '{}'.", (Object[])new Object[]{addFavoriteResourceRQ.getType()})});
        Shareable shareable = (Shareable)repository.findOne((Serializable)((Object)addFavoriteResourceRQ.getResourceId()));
        BusinessRule.expect((Object)shareable, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_ADD_TO_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"Incorrect resource id '{}'.", (Object[])new Object[]{addFavoriteResourceRQ.getResourceId()})});
        BusinessRule.expect((Object)shareable.getAcl().getEntries(), (Predicate)Preconditions.contains((Predicate)Preconditions.hasACLPermission((String)projectName, (AclPermissions)AclPermissions.READ))).verify(ErrorType.UNABLE_ADD_TO_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"Resource with id '{}' isn't shared to project.", (Object[])new Object[]{addFavoriteResourceRQ.getResourceId(), projectName})});
        BusinessRule.expect((Object)shareable.getAcl().getOwnerUserId(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)userName.toLowerCase()))).verify(ErrorType.UNABLE_ADD_TO_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"User can't add own resource to favorites", (Object[])new Object[0])});
        List resources = this.favoriteResourceRepository.findByFilter(Utils.getUniqueFavoriteFilter((String)userName, (String)addFavoriteResourceRQ.getType().name(), (String)addFavoriteResourceRQ.getResourceId()));
        BusinessRule.expect((Object)resources, (Predicate)Predicates.not((Predicate)Preconditions.NOT_EMPTY_COLLECTION)).verify(ErrorType.UNABLE_ADD_TO_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"Favorite resource with resource id '{}', type '{}' have already exist for user '{}'.", (Object[])new Object[]{addFavoriteResourceRQ.getResourceId(), addFavoriteResourceRQ.getType(), userName})});
    }
}

