/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.favorites.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.favorites.IRemoveFromFavoritesHandler;
import com.epam.ta.reportportal.core.favorites.impl.Utils;
import com.epam.ta.reportportal.database.dao.FavoriteResourceRepository;
import com.epam.ta.reportportal.database.entity.favorite.FavoriteResource;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoveFromFavoritesHandler
implements IRemoveFromFavoritesHandler {
    @Autowired
    private FavoriteResourceRepository favoriteResourceRepository;

    public OperationCompletionRS remove(String resourceType, String resourceId, String userName) {
        Filter filter = Utils.getUniqueFavoriteFilter((String)userName, (String)resourceType, (String)resourceId);
        List resources = this.favoriteResourceRepository.findByFilter(filter);
        BusinessRule.expect((Object)resources, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.UNABLE_REMOVE_FROM_FAVORITE, new Object[]{Suppliers.formattedSupplier((String)"Favorite resource with resource id '{}', type '{}' haven't found for user '{}'.", (Object[])new Object[]{resourceId, resourceType, userName})});
        this.favoriteResourceRepository.delete((Serializable)((Object)((FavoriteResource)resources.get(0)).getId()));
        return new OperationCompletionRS("Resource with ID = '" + resourceId + "' removed from favorites.");
    }
}

