/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.filter.ICreateUserFilterHandler;
import com.epam.ta.reportportal.core.filter.impl.UserFilterValidationService;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.ObjectType;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.converter.builders.UserFilterBuilder;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.filter.CreateUserFilterRQ;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CreateUserFilterHandler
implements ICreateUserFilterHandler {
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    @Qualifier(value="userFilterBuilder.reference")
    private LazyReference<UserFilterBuilder> userFilterBuilder;
    @Autowired
    private UserFilterValidationService userFilterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntryCreatedRS> createFilter(String userName, String projectName, CollectionsRQ<CreateUserFilterRQ> createFilterRQ) {
        ArrayList<UserFilter> filters = new ArrayList<UserFilter>();
        for (CreateUserFilterRQ rq : createFilterRQ.getElements()) {
            Set updatedEntries = this.userFilterService.validateUserFilterEntities(ObjectType.getTypeByName((String)rq.getObjectType()), rq.getEntities());
            rq.setEntities(updatedEntries);
            UserFilter userFilter = (UserFilter)((UserFilterBuilder)this.userFilterBuilder.get()).addCreateRQ(rq).addProject(projectName).addSharing(userName, projectName, rq.getShare() == null ? false : rq.getShare()).build();
            this.userFilterService.validateSortingColumnName(userFilter.getFilter().getTarget(), userFilter.getSelectionOptions().getSortingColumnName());
            filters.add(userFilter);
        }
        HashSet<String> filterNames = new HashSet<String>();
        CreateUserFilterHandler createUserFilterHandler = this;
        synchronized (createUserFilterHandler) {
            for (UserFilter userFilter : filters) {
                this.userFilterService.isFilterNameUnique(userName, userFilter.getName().trim(), projectName);
                filterNames.add(userFilter.getName());
            }
            BusinessRule.expect((Object)filterNames.size(), (Predicate)Predicates.equalTo((Object)filters.size())).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[0]);
            this.filterRepository.save(filters);
        }
        return filters.stream().map(filter -> new EntryCreatedRS(filter.getId())).collect(Collectors.toList());
    }
}

