/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.filter.IDeleteUserFilterHandler;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserFilterHandler
implements IDeleteUserFilterHandler {
    @Autowired
    private UserFilterRepository filterRepository;

    public OperationCompletionRS deleteFilter(String filterId, String userName, String projectName) {
        UserFilter userFilter = (UserFilter)this.filterRepository.findOne((Serializable)((Object)filterId));
        BusinessRule.expect((Object)userFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterId, userName});
        AclUtils.validateOwner((Acl)userFilter.getAcl(), (String)userName, (String)userFilter.getName());
        BusinessRule.expect((Object)userFilter.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        try {
            this.filterRepository.delete((Serializable)((Object)filterId));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting complex filter item", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        StringBuilder msg = new StringBuilder("User filter with ID = '");
        msg.append(filterId);
        msg.append("' successfully deleted.");
        response.setResultMessage(msg.toString());
        return response;
    }
}

