/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.CriteriaHolder;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.database.search.QueryBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserFilterValidationService {
    @Autowired
    private UserFilterRepository userFilterRepository;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;

    public void isFilterNameUnique(String userName, String filterName, String projectName) {
        UserFilter existingFilter = this.userFilterRepository.findOneByName(userName, filterName, projectName);
        BusinessRule.expect((Object)existingFilter, (Predicate)Predicates.isNull()).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{filterName, userName, projectName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UserFilterEntity> validateUserFilterEntities(Class<?> type, Set<UserFilterEntity> filterEntities) {
        HashSet<UserFilterEntity> remastered = new HashSet<UserFilterEntity>();
        CriteriaMap ctriteriaMap = this.criteriaMapFactory.getCriteriaMap(type);
        UserFilterValidationService userFilterValidationService = this;
        synchronized (userFilterValidationService) {
            Iterator<UserFilterEntity> it = filterEntities.iterator();
            while (it.hasNext()) {
                UserFilterEntity userFilterEntity = it.next();
                QueryBuilder.ComplexSearchCriteria filterCriteria = QueryBuilder.filterSearchCriteriaPreProcessor((String)userFilterEntity.getFilteringField());
                Optional holderOptional = ctriteriaMap.getCriteriaHolderUnchecked(filterCriteria.getGlobalSearchCriteria());
                BusinessRule.expect((Object)holderOptional, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Filter parameter {} is not defined", (Object[])new Object[]{filterCriteria.getGlobalSearchCriteria()})});
                CriteriaHolder updated = null;
                boolean reload = false;
                if (((CriteriaHolder)holderOptional.get()).getQueryCriteria().contains("statistics.issueCounter")) {
                    String rebuildedSearchCriteria = UserFilterValidationService.filterCriteriaRebuilder((String)userFilterEntity.getFilteringField());
                    UserFilterEntity newEntity = new UserFilterEntity(rebuildedSearchCriteria, userFilterEntity.getCondition(), userFilterEntity.getValue(), userFilterEntity.getIsNegative());
                    it.remove();
                    remastered.add(newEntity);
                    reload = true;
                    updated = new CriteriaHolder(((CriteriaHolder)holderOptional.get()).getFilterCriteria(), rebuildedSearchCriteria, Integer.class, ((CriteriaHolder)holderOptional.get()).isReference());
                }
                BusinessRule.expect((Object)holderOptional.isPresent(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Filtering field '{}' is unknown.", (Object[])new Object[]{userFilterEntity.getFilteringField()})});
                Condition condition = Condition.findByMarker((String)userFilterEntity.getCondition());
                BusinessRule.expect((Object)condition, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Incorrect filter's entity condition '{}'.", (Object[])new Object[]{userFilterEntity.getCondition()})});
                if (!reload) {
                    condition.validate((CriteriaHolder)holderOptional.get(), userFilterEntity.getValue(), userFilterEntity.getIsNegative(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                    condition.castValue((CriteriaHolder)holderOptional.get(), userFilterEntity.getValue(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                    continue;
                }
                condition.validate(updated, userFilterEntity.getValue(), userFilterEntity.getIsNegative(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                condition.castValue(updated, userFilterEntity.getValue(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
            }
        }
        filterEntities.addAll(remastered);
        return filterEntities;
    }

    public void validateSortingColumnName(Class<?> type, String sortingColumnName) {
        BusinessRule.expect((Object)this.criteriaMapFactory.getCriteriaMap(type).getCriteriaHolderUnchecked(sortingColumnName).isPresent(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Column for sorting with name '{}' is unknown.", (Object[])new Object[]{sortingColumnName})});
    }

    private static String filterCriteriaRebuilder(String input) {
        String[] split = input.split("\\$");
        StringBuilder builder = new StringBuilder(input);
        if (split.length <= 3) {
            builder.append("$").append("total");
        }
        return builder.toString();
    }
}

