/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.BusinessRuleViolationException;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.FailReferenceResourceRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.FailReferenceResource;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.converter.builders.FailReferenceResourceBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
class FinishTestItemHandlerImpl
implements FinishTestItemHandler {
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private TestItemRepository testItemRepository;
    private StatisticsFacadeFactory statisticsFacadeFactory;
    private FailReferenceResourceRepository issuesRepository;
    private LazyReference<FailReferenceResourceBuilder> failReferenceResourceBuilder;

    FinishTestItemHandlerImpl() {
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepo) {
        this.launchRepository = launchRepo;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setStatisticsFacadeFactory(StatisticsFacadeFactory statisticsFacadeFactory) {
        this.statisticsFacadeFactory = statisticsFacadeFactory;
    }

    @Autowired
    public void setFailReferenceResourceRepository(FailReferenceResourceRepository issuesRepository) {
        this.issuesRepository = issuesRepository;
    }

    @Autowired
    @Qualifier(value="failReferenceResourceBuilder.reference")
    public void setFailReferenceResourceBuilder(LazyReference<FailReferenceResourceBuilder> failReferenceResourceBuilder) {
        this.failReferenceResourceBuilder = failReferenceResourceBuilder;
    }

    public OperationCompletionRS finishTestItem(String testItemId, FinishTestItemRQ finishExecutionRQ, String username) {
        TestItem testItem = this.verifyTestItem(testItemId, finishExecutionRQ, Status.fromValue((String)finishExecutionRQ.getStatus()));
        testItem.setEndTime(finishExecutionRQ.getEndTime());
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchRef()});
        if (!launch.getUserRef().equalsIgnoreCase(username)) {
            BusinessRule.fail().withError(ErrorType.FINISH_ITEM_NOT_ALLOWED, new Object[]{"You are not launch owner."});
        }
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        Optional actualStatus = Status.fromValue((String)finishExecutionRQ.getStatus());
        Issue providedIssue = finishExecutionRQ.getIssue();
        boolean statusProvided = actualStatus.isPresent();
        boolean hasDescendants = this.testItemRepository.hasDescendants(new Object[]{testItem.getId()});
        if (!statusProvided && hasDescendants) {
            testItem.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)testItem.getStatistics()));
        } else {
            testItem.setStatus((Status)actualStatus.get());
        }
        if (!hasDescendants) {
            testItem = this.awareTestItemIssueTypeFromStatus(testItem, providedIssue, project);
        }
        try {
            this.testItemRepository.save((Object)testItem);
            if (!hasDescendants && null != (testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateExecutionStatistics(testItem)).getIssue()) {
                this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(testItem);
            }
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating TestItem " + e.getMessage(), (Throwable)e);
        }
        return new OperationCompletionRS("TestItem with ID = '" + testItemId + "' successfully finished.");
    }

    private TestItem verifyTestItem(String testItemId, FinishTestItemRQ finishExecutionRQ, Optional<Status> actualStatus) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        try {
            BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
            BusinessRule.expect((Object)testItem, (Predicate)Predicates.not((Predicate)Preconditions.TEST_ITEM_FINISHED)).verify(ErrorType.REPORTING_ITEM_ALREADY_FINISHED, new Object[]{testItem.getId()});
            boolean statusProvided = actualStatus.isPresent();
            List descendants = this.testItemRepository.findDescendants(new String[]{testItem.getId()});
            boolean hasDescendants = !descendants.isEmpty();
            BusinessRule.expect((Object)(!statusProvided && !hasDescendants ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE), (Supplier)Suppliers.formattedSupplier((String)"There is no status provided from request and there are no descendants to check statistics for test item id '{}'", (Object[])new Object[]{testItemId})).verify();
            BusinessRule.expect((Object)descendants, (Predicate)Predicates.not((Predicate)Preconditions.HAS_IN_PROGRESS_ITEMS)).verify(ErrorType.FINISH_ITEM_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Test item '{}' has descendants with '{}' status. All descendants '{}'", (Object[])new Object[]{testItemId, Status.IN_PROGRESS.name(), descendants})});
            BusinessRule.expect((Object)finishExecutionRQ, (Predicate)Preconditions.finishSameTimeOrLater((Date)testItem.getStartTime())).verify(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, new Object[]{finishExecutionRQ.getEndTime(), testItem.getStartTime(), testItemId});
        }
        catch (BusinessRuleViolationException e) {
            BusinessRule.fail().withError(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{e.getMessage()});
        }
        return testItem;
    }

    void verifyIssue(String testItemId, Issue issue, Project.Configuration projectSettings) {
        if (issue != null && !TestItemIssueType.NOT_ISSUE_FLAG.getValue().equalsIgnoreCase(issue.getIssueType())) {
            BusinessRule.expect((Object)projectSettings.getByLocator(issue.getIssueType()), (Predicate)Predicates.notNull()).verify(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Invalid test item issue type definition '{}' is requested for item '{}'. Valid issue types are: {}", (Object[])new Object[]{issue.getIssueType(), testItemId, TestItemIssueType.validValues()})});
        }
    }

    TestItem awareTestItemIssueTypeFromStatus(TestItem testItem, Issue providedIssue, Project project) {
        if (Status.FAILED.equals((Object)testItem.getStatus()) || Status.SKIPPED.equals((Object)testItem.getStatus())) {
            if (null != providedIssue) {
                this.verifyIssue(testItem.getId(), providedIssue, project.getConfiguration());
                String issueType = providedIssue.getIssueType();
                if (!issueType.equalsIgnoreCase(TestItemIssueType.NOT_ISSUE_FLAG.getValue())) {
                    testItem.setIssue(new TestItemIssue(project.getConfiguration().getByLocator(issueType).getLocator(), providedIssue.getComment()));
                }
            } else {
                testItem.setIssue(new TestItemIssue());
                Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
                BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchRef()});
                if (Mode.DEFAULT.equals((Object)launch.getMode()) && project.getConfiguration().getIsAutoAnalyzerEnabled().booleanValue()) {
                    this.finalizeFailed(testItem);
                }
            }
        }
        return testItem;
    }

    private void finalizeFailed(TestItem testItem) {
        FailReferenceResource resource = (FailReferenceResource)((FailReferenceResourceBuilder)this.failReferenceResourceBuilder.get()).addLaunchRef(testItem.getLaunchRef()).addTestItemRef(testItem.getId()).build();
        this.issuesRepository.save((Object)resource);
    }
}

