/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.converter.TestItemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
class GetTestItemHandlerImpl
implements GetTestItemHandler {
    private TestItemRepository testItemRepository;
    private TestItemResourceAssembler itemAssembler;
    private LaunchRepository launchRepository;

    @Autowired
    public GetTestItemHandlerImpl(TestItemRepository testItemRepository, TestItemResourceAssembler itemAssembler) {
        this.testItemRepository = testItemRepository;
        this.itemAssembler = itemAssembler;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    public TestItemResource getTestItem(String testItemId) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
        return this.itemAssembler.toResource(testItem);
    }

    public Iterable<TestItemResource> getTestItems(Filter filterable, Pageable pageable) {
        Page items = this.testItemRepository.findByFilter(filterable, pageable);
        String project = null;
        if (Preconditions.NOT_EMPTY_COLLECTION.test(items.getContent())) {
            project = ((Launch)this.launchRepository.findOne((Serializable)((Object)((TestItem)items.getContent().get(0)).getLaunchRef()))).getProjectRef();
        }
        return this.itemAssembler.toPagedResources(items, project);
    }

    public List<String> getTags(String launchId, String value) {
        return this.testItemRepository.findDistinctValues(launchId, value, "tags");
    }

    public List<TestItemResource> getTestItems(String[] ids) {
        Iterable testItems = this.testItemRepository.findAll(Arrays.asList(ids));
        return this.itemAssembler.toResources(testItems);
    }
}

