/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.BusinessRuleViolationException;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.util.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.epam.ta.reportportal.ws.model.item.AddExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.UpdateTestItemRQ;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateTestItemHandlerImpl
implements UpdateTestItemHandler {
    @Autowired
    private IIssuesAnalyzer analyzerService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;

    public List<Issue> defineTestItemsIssues(String projectName, DefineIssueRQ defineIssue, String userName) {
        ArrayList<String> errors = new ArrayList<String>();
        List definitions = defineIssue.getIssues();
        BusinessRule.expect((Object)definitions, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{""});
        ArrayList<Issue> updated = new ArrayList<Issue>(defineIssue.getIssues().size());
        ImmutableMap.Builder eventData = ImmutableMap.builder();
        for (IssueDefinition issueDefinition : definitions) {
            try {
                TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)issueDefinition.getId()));
                this.verifyTestItem(testItem, issueDefinition.getId());
                eventData.put((Object)issueDefinition, (Object)testItem);
                Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
                BusinessRule.expect((Object)this.analyzerService.isPossible(launch.getId()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Cannot update specified '{}' Test Item cause target Launch '{}' is processing by Auto-Analyze", (Object[])new Object[]{testItem.getId(), launch.getId()})});
                Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
                Issue issue = issueDefinition.getIssue();
                String issueType = this.verifyTestItemDefinedIssueType(issue.getIssueType(), project.getConfiguration());
                testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).resetIssueStatistics(testItem);
                TestItemIssue testItemIssue = testItem.getIssue();
                testItemIssue.setIssueType(issueType);
                String comment = issueDefinition.getIssue().getComment();
                if (null != comment) {
                    comment = comment.trim();
                }
                if (null != issue.getExternalSystemIssues()) {
                    Set issuesFromDB = null == testItemIssue.getExternalSystemIssues() ? new HashSet() : testItemIssue.getExternalSystemIssues();
                    Set issuesFromRequest = this.toDbExternalIssues(issue.getExternalSystemIssues(), userName);
                    HashSet difference = Sets.newHashSet((Iterable)Sets.difference((Set)issuesFromRequest, issuesFromDB));
                    if (!difference.isEmpty()) {
                        Set externalSystemIssues;
                        for (TestItemIssue.ExternalSystemIssue externalSystemIssue : difference) {
                            externalSystemIssue.setSubmitter(userName);
                            externalSystemIssue.setSubmitDate(Long.valueOf(new Date().getTime()));
                        }
                        if (issuesFromRequest.size() < issuesFromDB.size()) {
                            issuesFromRequest.removeAll(difference);
                            issuesFromRequest.addAll(difference);
                            externalSystemIssues = issuesFromRequest;
                        } else {
                            externalSystemIssues = issuesFromDB;
                            externalSystemIssues.addAll(difference);
                        }
                        testItemIssue.setExternalSystemIssues(externalSystemIssues);
                    } else {
                        issuesFromDB.removeAll(Sets.newHashSet((Iterable)Sets.difference(issuesFromDB, (Set)issuesFromRequest)));
                        testItemIssue.setExternalSystemIssues(issuesFromDB);
                    }
                }
                testItemIssue.setIssueDescription(comment);
                testItem.setIssue(testItemIssue);
                this.testItemRepository.save((Object)testItem);
                testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(testItem);
                updated.add(this.toIssue(testItem));
            }
            catch (BusinessRuleViolationException e) {
                errors.add(e.getMessage());
            }
        }
        BusinessRule.expect((Object)(!errors.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        this.eventPublisher.publishEvent((Object)new ItemIssueTypeDefined((Map)eventData.build(), userName, projectName));
        return updated;
    }

    public void verifyTestItem(TestItem testItem, String id) throws BusinessRuleViolationException {
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause it is not found.", (Object[])new Object[]{id})).verify();
        Status actualStatus = testItem.getStatus();
        BusinessRule.expect((Object)actualStatus, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)Status.PASSED)), (Supplier)Suppliers.formattedSupplier((String)"Issue status update cannot be applied on {} test items, cause it is not allowed.", (Object[])new Object[]{Status.PASSED.name()})).verify();
        boolean hasDescendants = this.testItemRepository.hasDescendants(new Object[]{testItem.getId()});
        BusinessRule.expect((Object)hasDescendants, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)Boolean.TRUE)), (Supplier)Suppliers.formattedSupplier((String)"It is not allowed to udpate issue type for items with descendants. Test item '{}' has descendants.", (Object[])new Object[]{id})).verify();
        TestItemIssue actualItemIssue = testItem.getIssue();
        BusinessRule.expect((Object)actualItemIssue, (Predicate)Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item '{}', cause there is no info about actual issue type value.", (Object[])new Object[]{id})).verify();
        String actualIssueType = actualItemIssue.getIssueType();
        BusinessRule.expect((Object)actualIssueType, (Predicate)Predicates.notNull(), (Supplier)Suppliers.formattedSupplier((String)"Cannot update issue type for test item {}, cause it's actual issue type value is not provided.", (Object[])new Object[]{id})).verify();
    }

    public String verifyTestItemDefinedIssueType(String type, Project.Configuration settings) {
        StatisticSubType defined = settings.getByLocator(type);
        BusinessRule.expect((Object)settings.getByLocator(type), (Predicate)Predicates.notNull()).verify(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{type});
        return defined.getLocator();
    }

    public OperationCompletionRS updateTestItem(String projectName, String item, UpdateTestItemRQ rq, String userName) {
        TestItem testItem = this.validate(projectName, userName, item);
        if (null != rq.getTags() || null != rq.getDescription()) {
            if (null != rq.getTags()) {
                testItem.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)rq.getTags()))));
            }
            if (null != rq.getDescription()) {
                testItem.setItemDescription(rq.getDescription().trim());
            }
            this.testItemRepository.save((Object)testItem);
        }
        return new OperationCompletionRS("TestItem with ID = '" + item + "' successfully updated.");
    }

    public List<OperationCompletionRS> addExternalIssues(String projectName, AddExternalIssueRQ rq, String userName) {
        ArrayList errors = new ArrayList();
        ExternalSystem extSystem = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)rq.getExternalSystemId()));
        BusinessRule.expect((Object)extSystem, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{rq.getExternalSystemId()});
        Iterable testItems = this.testItemRepository.findAll((Iterable)rq.getTestItemIds());
        List before = (List)((Object)SerializationUtils.clone((Serializable)Lists.newArrayList((Iterable)testItems)));
        StreamSupport.stream(testItems.spliterator(), false).forEach(testItem -> {
            try {
                this.verifyTestItem(testItem, testItem.getId());
                Set tiIssues = this.buildExternalSystemIssues(rq, userName);
                if (null == testItem.getIssue().getExternalSystemIssues()) {
                    testItem.getIssue().setExternalSystemIssues(tiIssues);
                } else {
                    tiIssues.addAll(testItem.getIssue().getExternalSystemIssues());
                    testItem.getIssue().setExternalSystemIssues(tiIssues);
                }
            }
            catch (BusinessRuleViolationException e) {
                errors.add(e.getMessage());
            }
        });
        BusinessRule.expect((Object)(!errors.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{((Object)errors).toString()});
        this.testItemRepository.save(testItems);
        this.eventPublisher.publishEvent((Object)new TicketAttachedEvent(before, (List)Lists.newArrayList((Iterable)testItems), userName, projectName));
        return StreamSupport.stream(testItems.spliterator(), false).map(testItem -> new OperationCompletionRS("TestItem with ID = '" + testItem.getId() + "' successfully updated.")).collect(Collectors.toList());
    }

    private Set<TestItemIssue.ExternalSystemIssue> buildExternalSystemIssues(AddExternalIssueRQ rq, String userName) {
        return rq.getIssues().stream().filter(issue -> !issue.getTicketId().trim().isEmpty()).map(issue -> {
            TestItemIssue.ExternalSystemIssue externalSystemIssue = new TestItemIssue.ExternalSystemIssue();
            externalSystemIssue.setTicketId(issue.getTicketId().trim());
            externalSystemIssue.setSubmitDate(Long.valueOf(new Date().getTime()));
            externalSystemIssue.setSubmitter(userName);
            externalSystemIssue.setExternalSystemId(rq.getExternalSystemId());
            externalSystemIssue.setUrl(issue.getUrl());
            return externalSystemIssue;
        }).collect(Collectors.toSet());
    }

    private Issue toIssue(TestItem item) {
        Issue issue = new Issue();
        TestItemIssue itemIssue = item.getIssue();
        issue.setComment(itemIssue.getIssueDescription());
        issue.setIssueType(itemIssue.getIssueType());
        if (null != item.getIssue().getExternalSystemIssues()) {
            issue.setExternalSystemIssues(this.toUiExternalIssues(item.getIssue().getExternalSystemIssues()));
        }
        return issue;
    }

    private Set<TestItemIssue.ExternalSystemIssue> toDbExternalIssues(Set<Issue.ExternalSystemIssue> issues, String userName) {
        return issues.stream().map(externalSystemIssue -> {
            TestItemIssue.ExternalSystemIssue dbExternalSystemIssue = new TestItemIssue.ExternalSystemIssue();
            dbExternalSystemIssue.setSubmitDate(Long.valueOf(new Date().getTime()));
            dbExternalSystemIssue.setSubmitter(userName);
            dbExternalSystemIssue.setTicketId(externalSystemIssue.getTicketId());
            dbExternalSystemIssue.setExternalSystemId(externalSystemIssue.getExternalSystemId());
            dbExternalSystemIssue.setUrl(externalSystemIssue.getUrl());
            return dbExternalSystemIssue;
        }).collect(Collectors.toSet());
    }

    private Set<Issue.ExternalSystemIssue> toUiExternalIssues(Set<TestItemIssue.ExternalSystemIssue> issues) {
        return issues.stream().map(externalSystemIssue -> {
            Issue.ExternalSystemIssue dbExternalSystemIssue = new Issue.ExternalSystemIssue();
            dbExternalSystemIssue.setSubmitDate(externalSystemIssue.getSubmitDate());
            dbExternalSystemIssue.setSubmitter(externalSystemIssue.getSubmitter());
            dbExternalSystemIssue.setTicketId(externalSystemIssue.getTicketId());
            dbExternalSystemIssue.setExternalSystemId(externalSystemIssue.getExternalSystemId());
            dbExternalSystemIssue.setUrl(externalSystemIssue.getUrl());
            return dbExternalSystemIssue;
        }).collect(Collectors.toSet());
    }

    private TestItem validate(String projectName, String userName, String id) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)id));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{id});
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        String launchOwner = launch.getUserRef();
        if (this.userRepository.findOne(userName).getRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)projectName, (Predicate)Predicates.equalTo((Object)project.getName())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (project.getUsers().containsKey(userName) && ((Project.UserConfig)project.getUsers().get(userName)).getProjectRole().getRoleLevel() < 2) {
                BusinessRule.expect((Object)userName, (Predicate)Predicates.equalTo((Object)launchOwner)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
        return testItem;
    }
}

