/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IDeleteLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.events.LaunchDeletedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteLaunchHandler
implements IDeleteLaunchHandler {
    private final LaunchRepository launchRepository;
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public DeleteLaunchHandler(ApplicationEventPublisher eventPublisher, LaunchRepository launchRepository, ProjectRepository projectRepository, UserRepository userRepository) {
        this.eventPublisher = eventPublisher;
        this.launchRepository = launchRepository;
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
    }

    public OperationCompletionRS deleteLaunch(String launchId, String projectName, String principal) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        User user = this.userRepository.findOne(principal);
        this.validate(launch, user, project);
        try {
            this.launchRepository.delete(Collections.singletonList(launchId));
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while Launch deleting.", (Throwable)exp);
        }
        this.eventPublisher.publishEvent((Object)new LaunchDeletedEvent(launch, principal));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully deleted.");
    }

    public List<OperationCompletionRS> deleteLaunches(String[] ids, String projectName, String userName) {
        List<String> toDelete = Arrays.asList(ids);
        List launches = this.launchRepository.find(toDelete);
        User user = this.userRepository.findOne(userName);
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        launches.forEach(launch -> this.validate(launch, user, project));
        this.launchRepository.delete(toDelete);
        return launches.stream().map(launch -> {
            this.eventPublisher.publishEvent((Object)new LaunchDeletedEvent(launch, userName));
            return new OperationCompletionRS("Launch with ID = '" + launch.getId() + "' successfully deleted.");
        }).collect(Collectors.toList());
    }

    private void validate(Launch launch, User user, Project project) {
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)project.getName())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Target launch '{}' not under specified project '{}'", (Object[])new Object[]{launch.getId(), project.getName()})});
        BusinessRule.expect((Object)launch, (Predicate)Predicates.not((Predicate)Preconditions.IN_PROGRESS)).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete launch '{}' in progress state", (Object[])new Object[]{launch.getId()})});
        if (user.getRole() != UserRole.ADMINISTRATOR && !user.getId().equalsIgnoreCase(launch.getUserRef())) {
            Project.UserConfig userConfig = (Project.UserConfig)project.getUsers().get(user.getId());
            BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles(Arrays.asList(ProjectRole.PROJECT_MANAGER, ProjectRole.LEAD))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }
}

