/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IGetLaunchHandler;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.ws.converter.LaunchResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetLaunchHandler
extends StatisticBasedContentLoader
implements IGetLaunchHandler {
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private LaunchResourceAssembler launchResourceAssember;

    @Autowired
    public GetLaunchHandler(LaunchResourceAssembler launchResourceAssembler, LaunchRepository launchRepository) {
        this.launchResourceAssember = (LaunchResourceAssembler)Preconditions.checkNotNull((Object)launchResourceAssembler);
        this.launchRepository = (LaunchRepository)Preconditions.checkNotNull((Object)launchRepository);
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public LaunchResource getLaunch(String launchId, String userName, String projectName) {
        Launch launch = this.validate(launchId, projectName);
        if (launch.getMode() == Mode.DEBUG) {
            Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
            Project.UserConfig userConfig = (Project.UserConfig)project.getUsers().get(userName);
            BusinessRule.expect((Object)userConfig.getProjectRole(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ProjectRole.CUSTOMER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        return this.launchResourceAssember.toResource(launch);
    }

    public LaunchResource getLaunchByName(String project, Pageable pageable, Filter filter, String username) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, project, "project"));
        Page launches = this.launchRepository.findByFilter(filter, pageable);
        BusinessRule.expect((Object)launches, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[0]);
        return this.launchResourceAssember.toResource((Launch)launches.iterator().next());
    }

    public Iterable<LaunchResource> getProjectLaunches(String projectName, Filter filter, Pageable pageable, String userName) {
        this.validateModeConditions(filter);
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.toString(), "mode"));
        Page launches = this.launchRepository.findByFilter(filter, pageable);
        return this.launchResourceAssember.toPagedResources(launches);
    }

    public Iterable<LaunchResource> getDebugLaunches(String projectName, String userName, Filter filter, Pageable pageable) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEBUG.toString(), "mode"));
        Page launches = this.launchRepository.findByFilter(filter, pageable);
        return this.launchResourceAssember.toPagedResources(launches);
    }

    public List<String> getTags(String project, String value) {
        return this.launchRepository.findDistinctValues(project, value, "tags");
    }

    public List<String> getLaunchNames(String project, String value) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the launch name string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, "name", Mode.DEFAULT.name());
    }

    public List<String> getOwners(String project, String value, String field, String mode) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, field, mode);
    }

    public Map<String, List<ChartObject>> getLaunchesComparisonInfo(String projectName, String[] ids) {
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        ArrayList<ChartObject> objects = new ArrayList<ChartObject>();
        List launches = this.launchRepository.find(Arrays.asList(ids));
        for (Launch launch : launches) {
            ChartObject object = new ChartObject();
            object.setName(launch.getName());
            object.setStartTime(String.valueOf(launch.getStartTime().getTime()));
            object.setNumber(String.valueOf(launch.getNumber()));
            object.setId(launch.getId());
            HashMap<String, Integer> issuesData = new HashMap<String, Integer>();
            IssueCounter issueCounter = launch.getStatistics().getIssueCounter();
            issuesData.put(this.getProductBugFieldName().replaceAll("\\.", "\\$"), issueCounter.getProductBugTotal());
            issuesData.put(this.getSystemIssueFieldName().replaceAll("\\.", "\\$"), issueCounter.getSystemIssueTotal());
            issuesData.put(this.getAutomationBugFieldName().replaceAll("\\.", "\\$"), issueCounter.getAutomationBugTotal());
            issuesData.put(this.getToInvestigateFieldName().replaceAll("\\.", "\\$"), issueCounter.getToInvestigateTotal());
            ExecutionCounter executionCounter = launch.getStatistics().getExecutionCounter();
            HashMap<String, Integer> executionData = new HashMap<String, Integer>();
            executionData.put(this.getFailedFieldName().replaceAll("\\.", "\\$"), executionCounter.getFailed());
            executionData.put(this.getPassedFieldName().replaceAll("\\.", "\\$"), executionCounter.getPassed());
            executionData.put(this.getSkippedFieldName().replaceAll("\\.", "\\$"), executionCounter.getSkipped());
            Map computedStatistics = this.computeFraction(issuesData);
            computedStatistics.putAll(this.computeFraction(executionData));
            object.setValues(computedStatistics);
            objects.add(object);
        }
        result.put("result", objects);
        return result;
    }

    public Map<String, String> getStatuses(String projectName, String[] ids) {
        return this.launchRepository.find(Arrays.asList(ids)).stream().filter(launch -> launch.getProjectRef().equals(projectName)).collect(Collectors.toMap(Launch::getId, launch -> launch.getStatus().toString()));
    }

    private Map<String, String> computeFraction(Map<String, Integer> data) {
        HashMap<String, String> result = new HashMap<String, String>();
        DecimalFormat formatter = new DecimalFormat("###.##");
        int total = data.values().stream().mapToInt(Integer::intValue).sum();
        String lastKey = null;
        Double lastValue = 0.0;
        Double sum = 0.0;
        Set<Map.Entry<String, Integer>> entries = data.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            String formattedValue = formatter.format(total != 0 ? (double)entry.getValue().intValue() / (double)total * 100.0 : 0.0);
            lastKey = entry.getKey();
            lastValue = Double.valueOf(formattedValue);
            sum = sum + lastValue;
            result.put(entry.getKey(), formattedValue);
        }
        if (total != 0) {
            result.put(lastKey, formatter.format(100.0 - (sum - lastValue)));
        }
        return result;
    }

    private void validateModeConditions(Filter filter) {
        BusinessRule.expect((Object)filter.getFilterConditions().stream().filter(com.epam.ta.reportportal.commons.Preconditions.HAS_ANY_MODE).findFirst().isPresent(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Filters for 'mode' aren't applicable for project's launches."});
    }

    private Launch validate(String launchId, String projectName) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project '{}'", (Object[])new Object[]{launchId, projectName})});
        return launch;
    }
}

