/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IUpdateLaunchHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchMetaInfoRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.launch.AutoAnalyzeStrategy;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.util.analyzer.IIssuesAnalyzer;
import com.epam.ta.reportportal.ws.converter.LaunchResourceAssembler;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.UpdateLaunchRQ;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UpdateLaunchHandler
implements IUpdateLaunchHandler {
    @Autowired
    private TestItemRepository testItemRepository;
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private UserRepository userRepository;
    @Autowired
    @Qualifier(value="launchBuilder.reference")
    private LazyReference<LaunchBuilder> launchBuilder;
    @Autowired
    private LaunchMetaInfoRepository launchCounter;
    @Autowired
    private LaunchResourceAssembler launchResourceAssembler;
    @Autowired
    private IIssuesAnalyzer analyzerService;
    @Autowired
    @Qualifier(value="autoAnalyzeTaskExecutor")
    private TaskExecutor taskExecutor;

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS updateLaunch(String launchId, String projectName, String userName, UpdateLaunchRQ rq) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        this.validate(launch, userName, projectName, rq.getMode());
        if (null != rq.getMode() || null != rq.getDescription() || null != rq.getTags()) {
            if (null != rq.getMode()) {
                launch.setMode(rq.getMode());
            }
            if (null != rq.getDescription()) {
                launch.setDescription(rq.getDescription().trim());
            }
            if (null != rq.getTags()) {
                launch.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)rq.getTags()))));
            }
            this.launchRepository.save((Object)launch);
        }
        return new OperationCompletionRS("Launch with ID = '" + launch.getId() + "' successfully updated.");
    }

    public LaunchResource mergeLaunches(String projectName, String userName, MergeLaunchesRQ mergeLaunchesRQ) {
        User user = this.userRepository.findOne(userName);
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Set launchesIds = mergeLaunchesRQ.getLaunches();
        List launchesList = this.launchRepository.find((Collection)launchesIds);
        this.validateMergingLaunches(launchesList, user, project);
        StartLaunchRQ startRQ = new StartLaunchRQ();
        startRQ.setMode(mergeLaunchesRQ.getMode());
        startRQ.setDescription(mergeLaunchesRQ.getDescription());
        startRQ.setName(mergeLaunchesRQ.getName());
        startRQ.setTags(mergeLaunchesRQ.getTags());
        launchesList.sort(Comparator.comparing(Launch::getStartTime));
        startRQ.setStartTime(((Launch)launchesList.get(0)).getStartTime());
        Launch launch = (Launch)((LaunchBuilder)this.launchBuilder.get()).addStartRQ(startRQ).addProject(projectName).addStatus(Status.IN_PROGRESS).addUser(userName).build();
        launch.setNumber(Long.valueOf(this.launchCounter.getLaunchNumber(launch.getName(), projectName)));
        this.launchRepository.save((Object)launch);
        launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
        launch.setEndTime(((Launch)launchesList.get(launchesList.size() - 1)).getEndTime());
        List statisticsBase = this.updateChildrenOfLaunch(launch.getId(), mergeLaunchesRQ.getLaunches(), mergeLaunchesRQ.isExtendSuitesDescription());
        launch.setStatistics(this.getLaunchStatisticFromItems(statisticsBase));
        launch.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics()));
        this.launchRepository.save((Object)launch);
        this.launchRepository.delete((Collection)launchesIds);
        return this.launchResourceAssembler.toResource(launch);
    }

    public OperationCompletionRS startLaunchAnalyzer(String projectName, String launchId, String scope) {
        AutoAnalyzeStrategy type = AutoAnalyzeStrategy.fromValue((String)scope);
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{scope});
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' is not under '{}' project.", (Object[])new Object[]{launchId, projectName})});
        BusinessRule.expect((Object)launch.getMode(), (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot analyze launches in debug mode."});
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (!this.analyzerService.isPossible(launchId) && type.equals((Object)AutoAnalyzeStrategy.HISTORY)) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' in auto-analyzer cache already", (Object[])new Object[]{launchId})});
        }
        if (!(!launch.getStatus().equals((Object)Status.IN_PROGRESS) && this.analyzerService.isPossible(launchId) || type.equals((Object)AutoAnalyzeStrategy.HISTORY))) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' in auto-analyzer cache already and/or in progress still", (Object[])new Object[]{launchId})});
        }
        List toInvestigate = this.testItemRepository.findInIssueTypeItems(TestItemIssueType.TO_INVESTIGATE.getLocator(), launchId);
        List got = type.equals((Object)AutoAnalyzeStrategy.SINGLE) ? this.analyzerService.collectPreviousIssues(1, launchId, projectName) : this.analyzerService.collectPreviousIssues(5, launchId, projectName);
        if (this.analyzerService.analyzeStarted(launchId)) {
            this.taskExecutor.execute(() -> this.analyzerService.analyze(launchId, toInvestigate, got));
        }
        return new OperationCompletionRS("Auto-analyzer for launch ID='" + launchId + "' started.");
    }

    public List<OperationCompletionRS> updateLaunch(BulkRQ<UpdateLaunchRQ> rq, String projectName, String userName) {
        return rq.getEntities().entrySet().stream().map(entry -> this.updateLaunch((String)entry.getKey(), projectName, userName, (UpdateLaunchRQ)entry.getValue())).collect(Collectors.toList());
    }

    private void validateMergingLaunches(List<Launch> launches, User user, Project project) {
        BusinessRule.expect((Object)launches.size(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)0))).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{launches});
        boolean isUserValidate = !user.getRole().equals((Object)UserRole.ADMINISTRATOR) && ((Project.UserConfig)project.getUsers().get(user.getId())).getProjectRole().getRoleLevel() < ProjectRole.LEAD.getRoleLevel();
        launches.stream().forEach(launch -> {
            BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launch});
            BusinessRule.expect((Object)this.analyzerService.isPossible(launch.getId()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to merge launch which under AA processing"});
            BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((Status[])new Status[]{Status.IN_PROGRESS}))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Cannot merge launch '{}' with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
            BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)project.getId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to merge launches from different projects."});
            if (isUserValidate) {
                BusinessRule.expect((Object)launch.getUserRef(), (Predicate)Predicates.equalTo((Object)user.getId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not an owner of launches or have less than LEAD project role."});
            }
        });
    }

    private void validate(Launch launch, String userName, String projectName, Mode mode) {
        String launchOwner = launch.getUserRef();
        User principal = this.userRepository.findOne(userName);
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        if (((Project.UserConfig)project.getUsers().get(userName)).getProjectRole() == ProjectRole.CUSTOMER && null != mode) {
            BusinessRule.expect((Object)mode, (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        if (principal.getRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (null == launchOwner || !launchOwner.equalsIgnoreCase(userName)) {
                Project.UserConfig userConfig = (Project.UserConfig)project.getUsers().get(userName);
                BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles((List)Lists.newArrayList((Object[])new ProjectRole[]{ProjectRole.PROJECT_MANAGER, ProjectRole.LEAD}))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            } else {
                BusinessRule.expect((Object)userName, (Predicate)Predicates.equalTo((Object)launchOwner)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
    }

    private List<TestItem> updateChildrenOfLaunch(String launchId, Set<String> launches, boolean extendDescription) {
        List testItems = launches.stream().map(id -> {
            Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)id));
            return this.testItemRepository.findByLaunch(launch).stream().map(item -> {
                item.setLaunchRef(launchId);
                if (item.getPath().size() == 0) {
                    Supplier newDescription = Suppliers.formattedSupplier((String)((null != item.getItemDescription() ? item.getItemDescription() : "") + (extendDescription ? "\r\n@launch '{} #{}'" : "")), (Object[])new Object[]{launch.getName(), launch.getNumber()});
                    item.setItemDescription((String)newDescription.get());
                }
                return item;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        this.testItemRepository.save(testItems);
        return testItems.stream().filter(item -> item.getPath().size() == 0).collect(Collectors.toList());
    }

    private Statistics getLaunchStatisticFromItems(List<TestItem> input) {
        ExecutionCounter execution = new ExecutionCounter();
        IssueCounter issues = new IssueCounter();
        for (TestItem item : input) {
            execution.setTotal(Integer.valueOf(item.getStatistics().getExecutionCounter().getTotal() + execution.getTotal()));
            execution.setPassed(Integer.valueOf(item.getStatistics().getExecutionCounter().getPassed() + execution.getPassed()));
            execution.setFailed(Integer.valueOf(item.getStatistics().getExecutionCounter().getFailed() + execution.getFailed()));
            execution.setSkipped(Integer.valueOf(item.getStatistics().getExecutionCounter().getSkipped() + execution.getSkipped()));
            issues = ProjectUtils.sumIssueStatistics((IssueCounter)issues, (IssueCounter)item.getStatistics().getIssueCounter());
        }
        return new Statistics(execution, issues);
    }
}

