/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.log.ICreateLogHandler;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.converter.builders.LogBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CreateLogHandler
implements ICreateLogHandler {
    protected TestItemRepository testItemRepository;
    protected LogRepository logRepository;
    private DataStorage dataStorage;
    protected LazyReference<LogBuilder> logBuilder;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setLogRepository(LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Autowired
    public void setDataStorage(DataStorage dataStorage) {
        this.dataStorage = dataStorage;
    }

    @Autowired
    @Qualifier(value="logBuilder.reference")
    public void setLogBuilder(LazyReference<LogBuilder> logBuilder) {
        this.logBuilder = logBuilder;
    }

    public EntryCreatedRS createLog(SaveLogRQ createLogRQ, BinaryData binaryData, String filename, String project) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)createLogRQ.getTestItemId()));
        this.validate(testItem, createLogRQ);
        BinaryContent binaryContent = null;
        if (null != binaryData) {
            String binaryDataId = this.dataStorage.saveData(binaryData, filename);
            binaryContent = new BinaryContent(binaryDataId, null, binaryData.getContentType());
        }
        Log log = (Log)((LogBuilder)this.logBuilder.get()).addSaveLogRQ(createLogRQ).addBinaryContent(binaryContent).addTestItem(testItem).build();
        try {
            this.logRepository.save((Object)log);
        }
        catch (Exception exc) {
            throw new ReportPortalException("Error while Log instance creating.", (Throwable)exc);
        }
        return new EntryCreatedRS(log.getId());
    }

    protected void validate(TestItem testItem, SaveLogRQ saveLogRQ) {
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.LOGGING_IS_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Logging to test item '{}' is not allowed. Probably you try to log for Launch type.", (Object[])new Object[]{saveLogRQ.getTestItemId()})});
        BusinessRule.expect((Object)testItem, (Predicate)Preconditions.IN_PROGRESS).verify(ErrorType.REPORTING_ITEM_ALREADY_FINISHED, new Object[]{testItem.getId()});
        BusinessRule.expect((Object)testItem.hasChilds(), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.LOGGING_IS_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Logging to item '{}' with descendants is not permitted", (Object[])new Object[]{testItem.getId()})});
        BusinessRule.expect((Object)testItem.getStartTime().before(saveLogRQ.getLogTime()), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.LOGGING_IS_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Log has incorrect log time. Log time should be after parent item's start time.", (Object[])new Object[0])});
        BusinessRule.expect((Object)LogLevel.toLevelOrUnknown((String)saveLogRQ.getLevel()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_SAVE_LOG_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Cannot convert '{}' to valid 'LogLevel'", (Object[])new Object[]{saveLogRQ.getLevel()})});
    }
}

