/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.log.IGetLogHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.converter.LogResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetLogHandler
implements IGetLogHandler {
    private LogRepository logRepository;
    private LogResourceAssembler logResourceAssembler;
    private TestItemRepository testItemRepository;
    private LaunchRepository launchRepository;

    @Autowired
    public void setLogRepository(LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Autowired
    public void setLogResourceAssembler(LogResourceAssembler logResourceAssembler) {
        this.logResourceAssembler = logResourceAssembler;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    public Iterable<LogResource> getLogs(String testStepId, String project, Filter filterable, Pageable pageable) {
        Page logs = this.logRepository.findByFilter(filterable, pageable);
        return this.logResourceAssembler.toPagedResources(logs, project);
    }

    public LogResource getLog(String logId, String projectName) {
        Log log = this.validate(logId, projectName);
        return this.logResourceAssembler.toResource(log);
    }

    private Log validate(String logId, String projectName) {
        Log log = (Log)this.logRepository.findOne((Serializable)((Object)logId));
        BusinessRule.expect((Object)log, (Predicate)Predicates.notNull()).verify(ErrorType.LOG_NOT_FOUND, new Object[]{logId});
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)log.getTestItemRef()));
        String project = ((Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()))).getProjectRef();
        BusinessRule.expect((Object)project, (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Log '{}' is not under specified project '{}'", (Object[])new Object[]{logId, projectName})});
        return log;
    }
}

