/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.ICreateProjectHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.converter.builders.ProjectBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.CreateProjectRQ;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CreateProjectHandler
implements ICreateProjectHandler {
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    @Qualifier(value="projectBuilder.reference")
    private LazyReference<ProjectBuilder> projectBuilder;

    public EntryCreatedRS createProject(CreateProjectRQ createProjectRQ, String username) {
        Project createdProject;
        String projectName = createProjectRQ.getProjectName().toLowerCase().trim();
        Project existProject = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)existProject, (Predicate)Predicates.isNull()).verify(ErrorType.PROJECT_ALREADY_EXISTS, new Object[]{projectName});
        Optional projectType = EntryType.findByName((String)createProjectRQ.getEntryType());
        BusinessRule.expect((Object)projectType, (Predicate)Predicates.isPresent()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{createProjectRQ.getEntryType()});
        BusinessRule.expect(projectType.get(), (Predicate)Predicates.equalTo((Object)EntryType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Only internal projects can be created via API"});
        Project project = (Project)((ProjectBuilder)this.projectBuilder.get()).addCreateProjectRQ(createProjectRQ).build();
        Project.UserConfig userConfig = new Project.UserConfig();
        userConfig.setProjectRole(ProjectRole.PROJECT_MANAGER);
        userConfig.setProposedRole(ProjectRole.PROJECT_MANAGER);
        project.getUsers().put(username, userConfig);
        try {
            createdProject = this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during creating Project", (Throwable)e);
        }
        return new EntryCreatedRS(createdProject.getId());
    }
}

