/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.IDeleteProjectHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteProjectHandler
implements IDeleteProjectHandler {
    private ProjectRepository projectRepository;

    @Autowired
    public DeleteProjectHandler(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS deleteProject(String projectName) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        BusinessRule.expect((Object)project.getConfiguration().getEntryType(), (Predicate)Predicates.and(Arrays.asList(Predicates.not((Predicate)Predicates.equalTo((Object)EntryType.PERSONAL)), Predicates.not((Predicate)Predicates.equalTo((Object)EntryType.UPSA))))).verify(ErrorType.PROJECT_UPDATE_NOT_ALLOWED, new Object[]{project.getConfiguration().getEntryType()});
        try {
            this.projectRepository.delete(Collections.singletonList(projectName));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting Project and attributes", (Throwable)e);
        }
        return new OperationCompletionRS("Project with name = '" + projectName + "' is successfully deleted.");
    }
}

