/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.SendCase;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.project.IUpdateProjectHandler;
import com.epam.ta.reportportal.database.dao.FavoriteResourceRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.ProjectSpecific;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.entity.user.UserUtils;
import com.epam.ta.reportportal.database.personal.PersonalProjectUtils;
import com.epam.ta.reportportal.events.EmailConfigUpdatedEvent;
import com.epam.ta.reportportal.events.ProjectUpdatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.epam.ta.reportportal.ws.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfig;
import com.epam.ta.reportportal.ws.model.project.email.UpdateProjectEmailRQ;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectHandler
implements IUpdateProjectHandler {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final FavoriteResourceRepository favoriteResourceRepository;
    private final UserPreferenceRepository preferenceRepository;
    private final ApplicationEventPublisher publisher;

    @Autowired
    public UpdateProjectHandler(ProjectRepository projectRepository, UserRepository userRepository, FavoriteResourceRepository favoriteResourceRepository, UserPreferenceRepository userPreferenceRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.favoriteResourceRepository = favoriteResourceRepository;
        this.preferenceRepository = userPreferenceRepository;
        this.publisher = applicationEventPublisher;
    }

    public OperationCompletionRS updateProject(String projectName, UpdateProjectRQ updateProjectRQ, String principalName) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        Project before = (Project)SerializationUtils.clone((Serializable)project);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (null != updateProjectRQ.getUserRoles()) {
            BusinessRule.expect(updateProjectRQ.getUserRoles().get(principalName), (Predicate)Predicates.isNull()).verify(ErrorType.UNABLE_TO_UPDATE_YOURSELF_ROLE, new Object[]{principalName});
        }
        if (null != updateProjectRQ.getCustomer()) {
            project.setCustomer(updateProjectRQ.getCustomer().trim());
        }
        project.setAddInfo(updateProjectRQ.getAddInfo());
        User principal = this.userRepository.findOne(principalName);
        if (null != updateProjectRQ.getUserRoles()) {
            for (Map.Entry user : updateProjectRQ.getUserRoles().entrySet()) {
                BusinessRule.expect((Object)project.getUsers(), (Predicate)Preconditions.containsKey(user.getKey())).verify(ErrorType.USER_NOT_FOUND, new Object[]{user.getKey(), Suppliers.formattedSupplier((String)"User '{}' not found in '{}' project", (Object[])new Object[]{user.getKey(), projectName})});
                Optional role = ProjectRole.forName((String)((String)user.getValue()));
                BusinessRule.expect((Object)role, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{user.getValue()});
                ProjectRole projectRole = (ProjectRole)role.get();
                if (UserRole.ADMINISTRATOR != principal.getRole()) {
                    int userRoleLevel;
                    int principalRoleLevel = ((Project.UserConfig)project.getUsers().get(principalName)).getProjectRole().getRoleLevel();
                    if (principalRoleLevel >= (userRoleLevel = ((Project.UserConfig)project.getUsers().get(user.getKey())).getProjectRole().getRoleLevel())) {
                        BusinessRule.expect((Object)projectRole.getRoleLevel(), (Predicate)Preconditions.isLevelEnough((int)principalRoleLevel)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    } else {
                        BusinessRule.expect((Object)userRoleLevel, (Predicate)Preconditions.isLevelEnough((int)principalRoleLevel)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    }
                }
                ((Project.UserConfig)project.getUsers().get(user.getKey())).setProjectRole((ProjectRole)role.get());
            }
        }
        if (null != updateProjectRQ.getConfiguration()) {
            ProjectConfiguration modelConfig = updateProjectRQ.getConfiguration();
            if (null != modelConfig.getKeepLogs()) {
                BusinessRule.expect((Object)KeepLogsDelay.findByName((String)modelConfig.getKeepLogs()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
                project.getConfiguration().setKeepLogs(modelConfig.getKeepLogs());
            }
            if (null != modelConfig.getInterruptJobTime()) {
                BusinessRule.expect((Object)InterruptionJobDelay.findByName((String)modelConfig.getInterruptJobTime()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
                project.getConfiguration().setInterruptJobTime(modelConfig.getInterruptJobTime());
            }
            if (null != modelConfig.getKeepScreenshots()) {
                BusinessRule.expect((Object)KeepScreenshotsDelay.findByName((String)modelConfig.getKeepScreenshots()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
                project.getConfiguration().setKeepScreenshots(modelConfig.getKeepScreenshots());
            }
            if (null != modelConfig.getProjectSpecific()) {
                BusinessRule.expect((Object)ProjectSpecific.findByName((String)modelConfig.getProjectSpecific()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
                project.getConfiguration().setProjectSpecific((ProjectSpecific)ProjectSpecific.findByName((String)modelConfig.getProjectSpecific()).get());
            }
            if (null != modelConfig.getIsAAEnabled()) {
                project.getConfiguration().setIsAutoAnalyzerEnabled(modelConfig.getIsAAEnabled().booleanValue());
            }
        }
        try {
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        this.publisher.publishEvent((Object)new ProjectUpdatedEvent(before, project, principalName, updateProjectRQ));
        return new OperationCompletionRS("Project with name = '" + projectName + "' is successfully updated.");
    }

    public OperationCompletionRS updateProjectEmailConfig(String projectName, String user, UpdateProjectEmailRQ updateProjectEmailRQ) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        Project beforeUpdate = (Project)SerializationUtils.clone((Serializable)project);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (null != updateProjectEmailRQ.getConfiguration()) {
            List cases;
            ProjectEmailConfig config = updateProjectEmailRQ.getConfiguration();
            if (null != config.getFrom()) {
                BusinessRule.expect((Object)UserUtils.isEmailValid((String)config.getFrom()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided FROM value '{}' is invalid", (Object[])new Object[]{config.getFrom()})});
                project.getConfiguration().getEmailConfig().setFrom(config.getFrom());
            }
            if (null != (cases = config.getEmailCases())) {
                BusinessRule.expect((Object)cases.isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"At least one rule should be present."});
                cases.forEach(sendCase -> {
                    BusinessRule.expect((Object)SendCase.findByName((String)sendCase.getSendCase()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{sendCase.getSendCase()});
                    BusinessRule.expect((Object)sendCase.getRecipients(), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Recipients list should not be null"});
                    BusinessRule.expect((Object)sendCase.getRecipients().isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Empty recipients list for email case '{}' ", (Object[])new Object[]{sendCase})});
                    sendCase.setRecipients(sendCase.getRecipients().stream().map(it -> {
                        this.validateRecipient(project, it);
                        return it.trim();
                    }).distinct().collect(Collectors.toList()));
                    if (null != sendCase.getLaunchNames()) {
                        sendCase.setLaunchNames(sendCase.getLaunchNames().stream().map(name -> {
                            this.validateLaunchName(name);
                            return name.trim();
                        }).distinct().collect(Collectors.toList()));
                    }
                    if (null != sendCase.getTags()) {
                        sendCase.setTags(sendCase.getTags().stream().map(tag -> {
                            BusinessRule.expect((Object)Strings.isNullOrEmpty((String)tag), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Tags values cannot be empty. Please specify it or not include in request."});
                            return tag.trim();
                        }).distinct().collect(Collectors.toList()));
                    }
                });
                List withoutDuplicateCases = cases.stream().distinct().collect(Collectors.toList());
                if (cases.size() != withoutDuplicateCases.size()) {
                    BusinessRule.fail().withError(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project email settings contain duplicate cases"});
                }
                project.getConfiguration().getEmailConfig().setEmailCases(cases);
            }
            if (!config.getEmailEnabled().booleanValue()) {
                ProjectUtils.setDefaultEmailCofiguration((Project)project);
            } else {
                project.getConfiguration().getEmailConfig().setEmailEnabled(true);
            }
        }
        try {
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        this.publisher.publishEvent((Object)new EmailConfigUpdatedEvent(beforeUpdate, updateProjectEmailRQ, user));
        return new OperationCompletionRS("EMail configuration of project with name = '" + projectName + "' is successfully updated.");
    }

    public OperationCompletionRS unassignUsers(String projectName, String modifier, UnassignUsersRQ unassignUsersRQ) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        EntryType projectType = project.getConfiguration().getEntryType();
        User principal = this.userRepository.findOne(modifier);
        if (UserRole.ADMINISTRATOR != principal.getRole()) {
            BusinessRule.expect((Object)unassignUsersRQ.getUsernames(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier)))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not unassign himself from project."});
        }
        Map users = project.getUsers();
        ArrayList<String> candidatesForUnassign = new ArrayList<String>();
        for (Object login : unassignUsersRQ.getUsernames()) {
            User singleUser = this.userRepository.findOne((String)login);
            BusinessRule.expect((Object)singleUser, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{login, "User is not found in database."});
            UserType userType = singleUser.getType();
            if (EntryType.PERSONAL.equals((Object)projectType) && projectName.equalsIgnoreCase(PersonalProjectUtils.personalProjectName((String)singleUser.getId()))) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Unable to unassign user from his personal project"});
            }
            if (projectType.equals((Object)EntryType.UPSA) && userType.equals((Object)UserType.UPSA)) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
            }
            if (!users.containsKey(singleUser.getId())) {
                BusinessRule.fail().withError(ErrorType.USER_NOT_FOUND, new Object[]{singleUser.getId(), String.format("User not found in project %s", projectName)});
            }
            if (UserRole.ADMINISTRATOR != principal.getRole()) {
                BusinessRule.expect((Object)((Project.UserConfig)users.get(singleUser.getId())).getProjectRole().getRoleLevel(), (Predicate)Preconditions.isLevelEnough((int)((Project.UserConfig)users.get(modifier)).getProjectRole().getRoleLevel())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
            candidatesForUnassign.add(singleUser.getId());
            users.remove(singleUser.getId());
        }
        Iterable dbUsers = this.userRepository.findAll(candidatesForUnassign);
        this.processCandidateForUnaassign(dbUsers, projectName);
        project = ProjectUtils.excludeProjectRecipients((Iterable)dbUsers, (Project)project);
        try {
            project.setUsers(users);
            this.projectRepository.save(project);
            for (String user : unassignUsersRQ.getUsernames()) {
                String normalized = user.toLowerCase();
                this.favoriteResourceRepository.removeFavoriteResources(normalized, projectName);
                this.preferenceRepository.deleteByUsernameAndProject(normalized, projectName);
            }
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project ", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        String msg = "User(s) with username(s)='" + unassignUsersRQ.getUsernames() + "' was successfully un-assigned from project='" + projectName + "'";
        response.setResultMessage(msg);
        return response;
    }

    public OperationCompletionRS assignUsers(String projectName, String modifier, AssignUsersRQ assignUsersRQ) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        EntryType projectType = project.getConfiguration().getEntryType();
        User principal = this.userRepository.findOne(modifier);
        if (!principal.getRole().equals((Object)UserRole.ADMINISTRATOR)) {
            BusinessRule.expect(assignUsersRQ.getUserNames().keySet(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier)))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not assign himself to project."});
        }
        for (String username : assignUsersRQ.getUserNames().keySet()) {
            BusinessRule.expect((Object)username.toLowerCase(), (Predicate)Predicates.not((Predicate)Predicates.in(project.getUsers().keySet()))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{Suppliers.formattedSupplier((String)"User '{}' cannot be assigned to project twice.", (Object[])new Object[]{username})});
        }
        Project.UserConfig principalRoles = (Project.UserConfig)project.getUsers().get(modifier);
        Map users = project.getUsers();
        for (String username : assignUsersRQ.getUserNames().keySet()) {
            User user = this.userRepository.findOne(username.toLowerCase());
            BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
            UserType userType = user.getType();
            if (projectType.equals((Object)EntryType.UPSA) && userType.equals((Object)UserType.UPSA)) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
            }
            Project.UserConfig config = new Project.UserConfig();
            String userToAssign = (String)assignUsersRQ.getUserNames().get(username);
            if (!Strings.isNullOrEmpty((String)userToAssign)) {
                Optional proposedRoleOptional = ProjectRole.forName((String)userToAssign);
                BusinessRule.expect((Object)proposedRoleOptional, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{userToAssign});
                ProjectRole proposedRole = (ProjectRole)proposedRoleOptional.get();
                if (principal.getRole() != UserRole.ADMINISTRATOR) {
                    int newUserProjectRoleLevel;
                    int creatorProjectRoleLevel = principalRoles.getProjectRole().getRoleLevel();
                    BusinessRule.expect((Object)(creatorProjectRoleLevel >= (newUserProjectRoleLevel = proposedRole.getRoleLevel()) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    config.setProjectRole(proposedRole);
                    config.setProposedRole(proposedRole);
                } else {
                    config.setProjectRole(proposedRole);
                    config.setProposedRole(proposedRole);
                }
            } else {
                config.setProjectRole(ProjectRole.MEMBER);
                config.setProposedRole(ProjectRole.MEMBER);
            }
            users.put(username.toLowerCase(), config);
        }
        try {
            project.setUsers(users);
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        String msg = "User(s) with username='" + assignUsersRQ.getUserNames().keySet() + "' was successfully assigned to project='" + projectName + "'";
        response.setResultMessage(msg);
        return response;
    }

    void validateRecipient(Project project, String recipient) {
        BusinessRule.expect((Object)recipient, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        if (recipient.contains("@")) {
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)recipient), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        } else {
            String login = recipient.trim();
            BusinessRule.expect((Object)(1 <= login.length() && login.length() <= 128 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Acceptable login length  [1..128]"});
            if (!ProjectUtils.getOwner().equals(login)) {
                BusinessRule.expect((Object)project.getUsers(), (Predicate)Preconditions.containsKey((Object)login.toLowerCase())).verify(ErrorType.USER_NOT_FOUND, new Object[]{login, String.format("User not found in project %s", project.getId())});
            }
        }
    }

    void validateLaunchName(String name) {
        BusinessRule.expect((Object)Strings.isNullOrEmpty((String)name), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch name values cannot be empty. Please specify it or not include in request."});
        BusinessRule.expect((Object)(name.length() <= 256 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"One of provided launch names '{}' is too long. Acceptable name length is [1..256]", (Object[])new Object[]{name})});
    }

    private void processCandidateForUnaassign(Iterable<User> users, String projectName) {
        List updated = StreamSupport.stream(users.spliterator(), false).filter(it -> it.getDefaultProject().equals(projectName)).map(it -> {
            it.setDefaultProject(PersonalProjectUtils.personalProjectName((String)it.getId()));
            return it;
        }).collect(Collectors.toList());
        this.userRepository.save(updated);
    }
}

