/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.settings.IDeleteProjectSettingsHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.widget.content.WidgetDataTypes;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.events.DefectTypeDeletedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteProjectSettingsHandler
implements IDeleteProjectSettingsHandler {
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS deleteProjectIssueSubType(String projectName, String user, String id) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Project projectsClone = (Project)SerializationUtils.clone((Serializable)project);
        StatisticSubType type = project.getConfiguration().getByLocator(id);
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{id});
        StatisticSubType group = project.getConfiguration().getByLocator(type.getTypeRef());
        if (Sets.newHashSet((Object[])new String[]{TestItemIssueType.AUTOMATION_BUG.getLocator(), TestItemIssueType.PRODUCT_BUG.getLocator(), TestItemIssueType.SYSTEM_ISSUE.getLocator(), TestItemIssueType.NO_DEFECT.getLocator(), TestItemIssueType.TO_INVESTIGATE.getLocator(), "total"}).contains(type.getLocator())) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot remove predefined global issue types."});
        }
        project.getConfiguration().getSubTypes().forEach((k, v) -> project.getConfiguration().getSubTypes().put(k, v.stream().filter(one -> !one.getLocator().equals(id)).collect(Collectors.toList())));
        List<String> ids = this.launchRepository.findLaunchesWithSpecificStat(projectName, type).stream().map(Launch::getId).collect(Collectors.toList());
        List items = this.testItemRepository.findForSpecifiedSubType(ids, false, type);
        items.stream().forEach(testItem -> {
            DeleteProjectSettingsHandler deleteProjectSettingsHandler = this;
            synchronized (deleteProjectSettingsHandler) {
                if (testItem.getIssue() != null && id.equals(testItem.getIssue().getIssueType())) {
                    testItem = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).resetIssueStatistics(testItem);
                    TestItemIssue testItemIssue = testItem.getIssue();
                    testItemIssue.setIssueType(group.getLocator());
                    this.testItemRepository.save(testItem);
                    this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(testItem);
                }
            }
        });
        ids.forEach(launch -> this.launchRepository.dropIssueStatisticsType(launch, type));
        items.forEach(testItem -> this.testItemRepository.dropIssueStatisticsType(testItem.getId(), type));
        List testItemsAddition = this.testItemRepository.findForSpecifiedSubType(ids, true, type);
        testItemsAddition.forEach(testItem -> this.testItemRepository.dropIssueStatisticsType(testItem.getId(), type));
        try {
            this.projectRepository.save(project);
            this.widgetRepository.findByProject(projectName).stream().filter(it -> {
                String widgetType = it.getContentOptions().getType();
                return widgetType.equals(WidgetDataTypes.LINE_CHART.getType()) || widgetType.equals(WidgetDataTypes.COLUMN_CHART.getType()) || widgetType.equals(WidgetDataTypes.LAUNCHES_TABLE.getType()) || widgetType.equals(WidgetDataTypes.TABLE.getType()) || widgetType.equals(WidgetDataTypes.PIE_CHART.getType()) || widgetType.equals(WidgetDataTypes.STATISTICS_PANEL.getType()) || widgetType.equals(WidgetDataTypes.TRENDS_CHART.getType());
            }).forEach(it -> this.widgetRepository.removeContentField(it.getId(), "statistics$defects$" + type.getTypeRef().toLowerCase() + "$" + id));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during project settings issue sub-type update saving.", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new DefectTypeDeletedEvent(id, projectsClone, user));
        return new OperationCompletionRS("Issue sub-type delete operation completed successfully.");
    }
}

