/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.statistics;

import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsFacadeImpl
implements StatisticsFacade {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private ProjectRepository projectRepository;

    public TestItem updateExecutionStatistics(TestItem testItem) {
        this.testItemRepository.updateExecutionStatistics((Object)testItem);
        this.launchRepository.updateExecutionStatistics((Object)testItem);
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public TestItem updateIssueStatistics(TestItem testItem) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        this.testItemRepository.updateIssueStatistics((Object)testItem, (Object)project.getConfiguration());
        this.launchRepository.updateIssueStatistics((Object)testItem, (Object)project.getConfiguration());
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public TestItem resetIssueStatistics(TestItem testItem) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
        this.testItemRepository.resetIssueStatistics((Object)testItem, (Object)project.getConfiguration());
        this.launchRepository.resetIssueStatistics((Object)testItem, (Object)project.getConfiguration());
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public TestItem resetExecutionStatistics(TestItem testItem) {
        this.testItemRepository.resetExecutionStatistics((Object)testItem);
        this.launchRepository.resetExecutionStatistics((Object)testItem);
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public TestItem deleteIssueStatistics(TestItem testItem) {
        this.testItemRepository.deleteIssueStatistics((Object)testItem);
        this.launchRepository.deleteIssueStatistics((Object)testItem);
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public TestItem deleteExecutionStatistics(TestItem testItem) {
        this.testItemRepository.deleteExecutionStatistics((Object)testItem);
        this.launchRepository.deleteExecutionStatistics((Object)testItem);
        return (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getId()));
    }

    public void updateParentStatusFromStatistics(TestItem item) {
        item.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)item.getStatistics()));
        this.testItemRepository.save((Object)item);
        if (null != item.getParent()) {
            TestItem parent = (TestItem)this.testItemRepository.findOne((Serializable)((Object)item.getParent()));
            this.updateParentStatusFromStatistics(parent);
        }
    }

    public void updateLaunchFromStatistics(Launch launch) {
        launch.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics()));
        this.launchRepository.save((Object)launch);
    }
}

