/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="ChartInvestigatedContentLoader")
public class ChartInvestigatedContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    @Autowired
    private LaunchRepository launchRepository;

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public Map<String, List<ChartObject>> loadContent(Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        BusinessRule.expect((Object)(metaDataFields == null || metaDataFields.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Metadata fields should exist for providing content for 'column chart'."});
        ArrayList allFields = Lists.newArrayList(contentFields);
        List<String> xAxis = metaDataFields;
        allFields.addAll(xAxis);
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(contentFields, xAxis);
        String collectionName = ChartInvestigatedContentLoader.getCollectionName((Class)filter.getTarget());
        this.launchRepository.loadWithCallback(filter, sorting, quantity, (List)allFields, (DocumentCallbackHandler)handler, collectionName);
        if (options.get("timeline") != null && StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)) != null) {
            return this.convertResult(this.groupByDate(handler.getResult(), StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0))));
        }
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("result", handler.getResult());
        return this.convertResult(result);
    }

    private Map<String, List<ChartObject>> convertResult(Map<String, List<ChartObject>> initial) {
        if (initial.size() == 0) {
            return new HashMap<String, List<ChartObject>>();
        }
        for (Map.Entry<String, List<ChartObject>> entry : initial.entrySet()) {
            entry.getValue().stream().forEach(chart -> {
                chart = this.getInvestigationStatistic(chart);
            });
        }
        return initial;
    }

    private ChartObject getInvestigationStatistic(ChartObject init) {
        DecimalFormat formatter = new DecimalFormat("###.##");
        String INVESTIGATED = "investigated";
        String TO_INVESTIGATE = "to_investigate";
        HashMap<String, String> additionalValues = new HashMap<String, String>();
        double investigated = 0.0;
        double toInvestigate = 0.0;
        for (String key : init.getValues().keySet()) {
            if (this.getIssueStatFields().contains(key)) {
                investigated += Double.valueOf((String)init.getValues().get(key)).doubleValue();
            }
            if (!key.equalsIgnoreCase(this.getToInvestigateFieldName())) continue;
            toInvestigate = Double.valueOf((String)init.getValues().get(key));
        }
        if (investigated + toInvestigate > 0.0) {
            double investigatedPercent = investigated / (investigated + toInvestigate) * 100.0;
            double toInvestigatePercent = 100.0 - investigatedPercent;
            additionalValues.put("investigated", formatter.format(investigatedPercent));
            additionalValues.put("to_investigate", formatter.format(toInvestigatePercent));
        } else {
            additionalValues.put("investigated", formatter.format(0L));
            additionalValues.put("to_investigate", formatter.format(0L));
        }
        init.setValues(additionalValues);
        return init;
    }
}

