/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="LaunchesComparisonChart")
public class LaunchesComparisonContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    private static final Integer QUANTITY = 2;
    @Autowired
    private LaunchRepository launchRepository;

    public Map<String, List<ChartObject>> loadContent(Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        if (filter.getTarget().equals(TestItem.class)) {
            return new HashMap<String, List<ChartObject>>();
        }
        StatisticsDocumentHandler documentHandler = new StatisticsDocumentHandler(contentFields, metaDataFields);
        ArrayList allFields = Lists.newArrayList(contentFields);
        allFields.addAll(metaDataFields);
        String collectionName = LaunchesComparisonContentLoader.getCollectionName((Class)filter.getTarget());
        this.launchRepository.loadWithCallback(filter, sorting, QUANTITY.intValue(), (List)allFields, (DocumentCallbackHandler)documentHandler, collectionName);
        return this.convertResult(documentHandler.getResult());
    }

    private Map<String, List<ChartObject>> convertResult(List<ChartObject> objects) {
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        DecimalFormat formatter = new DecimalFormat("###.##");
        for (ChartObject object : objects) {
            HashMap<String, String> values = new HashMap<String, String>();
            Double totalValue = Double.valueOf((String)object.getValues().get(this.getTotalFieldName()));
            values.put(this.getTotalFieldName(), formatter.format(totalValue));
            Double failedItems = totalValue.intValue() == 0 ? 0.0 : Double.valueOf((String)object.getValues().get(this.getFailedFieldName())) / totalValue * 100.0;
            values.put(this.getFailedFieldName(), formatter.format(failedItems));
            Double skippedItems = totalValue.intValue() == 0 ? 0.0 : Double.valueOf((String)object.getValues().get(this.getSkippedFieldName())) / totalValue * 100.0;
            values.put(this.getSkippedFieldName(), formatter.format(skippedItems));
            values.put(this.getPassedFieldName(), formatter.format(totalValue.intValue() == 0 ? 0.0 : 100.0 - failedItems - skippedItems));
            int toInvestigateQuantity = Integer.parseInt((String)object.getValues().get(this.getToInvestigateFieldName()));
            int productBugsQuantity = Integer.parseInt((String)object.getValues().get(this.getProductBugFieldName()));
            int systemIssuesQuantity = Integer.parseInt((String)object.getValues().get(this.getSystemIssueFieldName()));
            int testBugsQuantity = Integer.parseInt((String)object.getValues().get(this.getAutomationBugFieldName()));
            String noDefectValue = (String)object.getValues().get(this.getNoDefectFieldName());
            int noDefectQuantity = noDefectValue == null ? 0 : Integer.parseInt(noDefectValue);
            int failedQuantity = toInvestigateQuantity + productBugsQuantity + systemIssuesQuantity + testBugsQuantity + noDefectQuantity;
            if (failedQuantity != 0) {
                Double investigatedItems = (double)toInvestigateQuantity / (double)failedQuantity * 100.0;
                values.put(this.getToInvestigateFieldName(), formatter.format(investigatedItems));
                Double productBugItems = (double)productBugsQuantity / (double)failedQuantity * 100.0;
                values.put(this.getProductBugFieldName(), formatter.format(productBugItems));
                Double systemIssueItems = (double)systemIssuesQuantity / (double)failedQuantity * 100.0;
                values.put(this.getSystemIssueFieldName(), formatter.format(systemIssueItems));
                Double noDefectItems = (double)noDefectQuantity / (double)failedQuantity * 100.0;
                values.put(this.getNoDefectFieldName(), formatter.format(noDefectItems));
                values.put(this.getAutomationBugFieldName(), formatter.format(100.0 - investigatedItems - productBugItems - systemIssueItems - noDefectItems));
            } else {
                String formatted = formatter.format(0.0);
                values.put(this.getToInvestigateFieldName(), formatted);
                values.put(this.getProductBugFieldName(), formatted);
                values.put(this.getSystemIssueFieldName(), formatted);
                values.put(this.getAutomationBugFieldName(), formatted);
                values.put(this.getNoDefectFieldName(), formatted);
            }
            object.setValues(values);
        }
        result.put("result", objects);
        return result;
    }
}

