/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class StatisticBasedContentLoader {
    public static final String RESULT = "result";
    private static final List<String> STATZZ = Arrays.asList("statistics.executionCounter.passed", "statistics.executionCounter.failed", "statistics.executionCounter.skipped");
    private static final String PASSED = "statistics.executionCounter.passed";
    private static final String FAILED = "statistics.executionCounter.failed";
    private static final String SKIPPED = "statistics.executionCounter.skipped";
    private static final String TOTAL = "statistics.executionCounter.total";
    private static final List<String> BUGZZ = Arrays.asList("statistics.issueCounter.productBug.total", "statistics.issueCounter.automationBug.total", "statistics.issueCounter.systemIssue.total", "statistics.issueCounter.noDefect.total");
    private static final String TO_INVESTIGATE = "statistics.issueCounter.toInvestigate.total";
    private static final String PRODUCT_BUG = "statistics.issueCounter.productBug.total";
    private static final String AUTOMATION_BUG = "statistics.issueCounter.automationBug.total";
    private static final String SYSTEM_ISSUE = "statistics.issueCounter.systemIssue.total";
    private static final String NO_DEFECT = "statistics.issueCounter.noDefect.total";
    private static final String DATE_PATTERN = "yyyy-MM-dd";

    public static String getCollectionName(Class<?> type) {
        char[] chars = type.getSimpleName().toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public List<String> getExecutionStatFields() {
        return STATZZ;
    }

    public List<String> getIssueStatFields() {
        return BUGZZ;
    }

    public String getPassedFieldName() {
        return PASSED;
    }

    public String getFailedFieldName() {
        return FAILED;
    }

    public String getSkippedFieldName() {
        return SKIPPED;
    }

    public String getTotalFieldName() {
        return TOTAL;
    }

    public String getToInvestigateFieldName() {
        return TO_INVESTIGATE;
    }

    public String getProductBugFieldName() {
        return PRODUCT_BUG;
    }

    public String getAutomationBugFieldName() {
        return AUTOMATION_BUG;
    }

    public String getSystemIssueFieldName() {
        return SYSTEM_ISSUE;
    }

    public String getNoDefectFieldName() {
        return NO_DEFECT;
    }

    public Map<String, List<ChartObject>> groupByDate(List<ChartObject> input, Period period) {
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        Map range = this.buildRange(input, period);
        for (ChartObject anInput : input) {
            String group = new DateTime((Object)Long.valueOf(anInput.getStartTime())).toString(DATE_PATTERN);
            ChartObject axisObject = (ChartObject)range.get(group);
            Map values = axisObject.getValues();
            HashMap<String, String> updated = new HashMap<String, String>();
            for (String key : anInput.getValues().keySet()) {
                updated.put(key, String.valueOf(Double.valueOf((String)anInput.getValues().get(key)) + Double.valueOf((String)values.get(key))));
            }
            axisObject.setValues(updated);
            range.put(group, axisObject);
        }
        range.keySet().stream().forEach(date -> result.put((String)date, Collections.singletonList(range.get(date))));
        return result;
    }

    public Map<String, List<ChartObject>> maxByDate(List<ChartObject> input, Period period, String maxSeries) {
        Function<ChartObject, String> chartObjectToDate = chartObject -> new DateTime((Object)Long.valueOf(chartObject.getStartTime())).toString(DATE_PATTERN);
        BinaryOperator chartObjectReducer = (o1, o2) -> Integer.valueOf((String)o1.getValues().get(maxSeries)) > Integer.valueOf((String)o2.getValues().get(maxSeries)) ? o1 : o2;
        Map groupByDate = input.stream().sorted(Comparator.comparing(ChartObject::getStartTime)).collect(Collectors.groupingBy(chartObjectToDate, LinkedHashMap::new, Collectors.reducing(chartObjectReducer)));
        Map range = this.buildRange(input, period);
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        range.forEach((key, value) -> result.put((String)key, Collections.singletonList(groupByDate.getOrDefault(key, Optional.of(this.createChartObject((ChartObject)input.get(0)))).get())));
        return result;
    }

    private ChartObject createChartObject(ChartObject input) {
        ChartObject chartObject = new ChartObject();
        chartObject.setValues(input.getValues().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "0")));
        return chartObject;
    }

    private Map<String, ChartObject> buildRange(List<ChartObject> base, Period period) {
        LongSummaryStatistics statistics = base.stream().mapToLong(object -> Long.valueOf(object.getStartTime())).summaryStatistics();
        DateTime start = new DateTime(statistics.getMin());
        DateTime end = new DateTime(statistics.getMax());
        DateTime intermediate = start;
        LinkedHashMap<String, ChartObject> map = new LinkedHashMap<String, ChartObject>();
        if (base.isEmpty()) {
            return map;
        }
        while (intermediate.isBefore((ReadableInstant)end)) {
            map.put(intermediate.toString(DATE_PATTERN), this.createChartObject(base.get(0)));
            switch (1.$SwitchMap$com$epam$ta$reportportal$core$widget$content$StatisticBasedContentLoader$Period[period.ordinal()]) {
                case 1: {
                    intermediate = intermediate.plusDays(1);
                    break;
                }
                case 2: {
                    intermediate = intermediate.plusDays(1);
                    break;
                }
                case 3: {
                    intermediate = intermediate.plusMonths(1);
                }
            }
        }
        map.put(end.toString(DATE_PATTERN), this.createChartObject(base.get(0)));
        return map;
    }
}

