/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.content.WidgetDataTypes;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.QueryBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.function.Predicate;

public class WidgetUtils {
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String START_TIME = "start_time";
    public static final String USER = "user";

    private WidgetUtils() {
    }

    public static void validateFields(Iterable<String> fields, CriteriaMap<?> criteriaMap, ErrorType errorType) {
        if (fields == null || criteriaMap == null || errorType == null) {
            return;
        }
        for (String field : fields) {
            QueryBuilder.ComplexSearchCriteria filterCriteria = QueryBuilder.filterSearchCriteriaPreProcessor((String)field);
            BusinessRule.expect((Object)criteriaMap.getCriteriaHolderUnchecked(filterCriteria.getGlobalSearchCriteria()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Field '{}' cannot be used for calculating data for widget.", (Object[])new Object[]{field})});
        }
    }

    public static void validateWidgetDataType(String type, ErrorType errorType) {
        BusinessRule.expect((Object)WidgetDataTypes.findByName((String)type).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Unknown widget data type: '{}'. Possible data types: line_chart, bar_chart, column_chart, pie_chart, table", (Object[])new Object[]{type})});
    }

    public static void validateGadgetType(String gadget, ErrorType errorType) {
        BusinessRule.expect((Object)GadgetTypes.findByName((String)gadget).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{gadget})});
    }

    public static void checkUniqueName(String newWidgetName, List<Widget> existingWidgets) {
        if (null != existingWidgets) {
            for (Widget existingWidget : existingWidgets) {
                BusinessRule.expect((Object)existingWidget.getName().equals(newWidgetName), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{newWidgetName});
            }
        }
    }
}

